// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainBehavior domain behavior
//
// swagger:model domain.Behavior
type DomainBehavior struct {

	// aid
	Aid string `json:"aid,omitempty"`

	// alert ids
	AlertIds []string `json:"alert_ids"`

	// behavior id
	BehaviorID string `json:"behavior_id,omitempty"`

	// cid
	Cid string `json:"cid,omitempty"`

	// cmdline
	Cmdline string `json:"cmdline,omitempty"`

	// compound tto
	CompoundTto string `json:"compound_tto,omitempty"`

	// detection ids
	DetectionIds []string `json:"detection_ids"`

	// display name
	DisplayName string `json:"display_name,omitempty"`

	// domain
	Domain string `json:"domain,omitempty"`

	// exclusion type
	ExclusionType string `json:"exclusion_type,omitempty"`

	// filepath
	Filepath string `json:"filepath,omitempty"`

	// incident id
	IncidentID string `json:"incident_id,omitempty"`

	// incident ids
	IncidentIds []string `json:"incident_ids"`

	// ioc source
	IocSource string `json:"ioc_source,omitempty"`

	// ioc type
	IocType string `json:"ioc_type,omitempty"`

	// ioc value
	IocValue string `json:"ioc_value,omitempty"`

	// objective
	Objective string `json:"objective,omitempty"`

	// pattern disposition
	PatternDisposition int32 `json:"pattern_disposition,omitempty"`

	// pattern disposition details
	PatternDispositionDetails *PatterndispositionPatternDisposition `json:"pattern_disposition_details,omitempty"`

	// pattern id
	// Required: true
	PatternID *int32 `json:"pattern_id"`

	// sha256
	Sha256 string `json:"sha256,omitempty"`

	// tactic
	Tactic string `json:"tactic,omitempty"`

	// tactic id
	TacticID string `json:"tactic_id,omitempty"`

	// technique
	Technique string `json:"technique,omitempty"`

	// technique id
	TechniqueID string `json:"technique_id,omitempty"`

	// template instance id
	// Required: true
	TemplateInstanceID *int32 `json:"template_instance_id"`

	// timestamp
	// Required: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp"`

	// user name
	UserName string `json:"user_name,omitempty"`
}

// Validate validates this domain behavior
func (m *DomainBehavior) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePatternDispositionDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePatternID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTemplateInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainBehavior) validatePatternDispositionDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.PatternDispositionDetails) { // not required
		return nil
	}

	if m.PatternDispositionDetails != nil {
		if err := m.PatternDispositionDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pattern_disposition_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pattern_disposition_details")
			}
			return err
		}
	}

	return nil
}

func (m *DomainBehavior) validatePatternID(formats strfmt.Registry) error {

	if err := validate.Required("pattern_id", "body", m.PatternID); err != nil {
		return err
	}

	return nil
}

func (m *DomainBehavior) validateTemplateInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("template_instance_id", "body", m.TemplateInstanceID); err != nil {
		return err
	}

	return nil
}

func (m *DomainBehavior) validateTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain behavior based on the context it is used
func (m *DomainBehavior) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePatternDispositionDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainBehavior) contextValidatePatternDispositionDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.PatternDispositionDetails != nil {

		if swag.IsZero(m.PatternDispositionDetails) { // not required
			return nil
		}

		if err := m.PatternDispositionDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pattern_disposition_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pattern_disposition_details")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainBehavior) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainBehavior) UnmarshalBinary(b []byte) error {
	var res DomainBehavior
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
