// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainBotnetConfigSource domain botnet config source
//
// swagger:model domain.BotnetConfigSource
type DomainBotnetConfigSource struct {

	// Populated for action botnets. List of action key value pairs, defined as the action and its type
	// Required: true
	Actions []*DomainKeyValuePair `json:"actions"`

	// Populated for spam botnets. The body of the spam template. If this contains replaceable variables, keep the variable names in the template as they appear in the raw config
	// Required: true
	Body *string `json:"body"`

	// The botnet's name
	// Required: true
	Botnet *string `json:"botnet"`

	// The type of botnet: `action`, `inject`, or `spam`
	// Required: true
	ConfigType *string `json:"config_type"`

	// Populated for inject botnets. List of inject targets and their data
	// Required: true
	Injects []*DomainBotnetInject `json:"injects"`

	// Optional sub-botnet differentiator
	// Required: true
	SubBotnet *string `json:"sub_botnet"`

	// Populated for spam botnets. The subject of the spam template. If this contains replaceable variables, keep the variable names in the template as they appear in the raw config
	// Required: true
	Subject *string `json:"subject"`

	// Populated for spam botnets. List of key value pairs for any replaceable variables in the spam template
	// Required: true
	Variables []*DomainKeyValuePair `json:"variables"`
}

// Validate validates this domain botnet config source
func (m *DomainBotnetConfigSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBody(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBotnet(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInjects(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubBotnet(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariables(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainBotnetConfigSource) validateActions(formats strfmt.Registry) error {

	if err := validate.Required("actions", "body", m.Actions); err != nil {
		return err
	}

	for i := 0; i < len(m.Actions); i++ {
		if swag.IsZero(m.Actions[i]) { // not required
			continue
		}

		if m.Actions[i] != nil {
			if err := m.Actions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainBotnetConfigSource) validateBody(formats strfmt.Registry) error {

	if err := validate.Required("body", "body", m.Body); err != nil {
		return err
	}

	return nil
}

func (m *DomainBotnetConfigSource) validateBotnet(formats strfmt.Registry) error {

	if err := validate.Required("botnet", "body", m.Botnet); err != nil {
		return err
	}

	return nil
}

func (m *DomainBotnetConfigSource) validateConfigType(formats strfmt.Registry) error {

	if err := validate.Required("config_type", "body", m.ConfigType); err != nil {
		return err
	}

	return nil
}

func (m *DomainBotnetConfigSource) validateInjects(formats strfmt.Registry) error {

	if err := validate.Required("injects", "body", m.Injects); err != nil {
		return err
	}

	for i := 0; i < len(m.Injects); i++ {
		if swag.IsZero(m.Injects[i]) { // not required
			continue
		}

		if m.Injects[i] != nil {
			if err := m.Injects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("injects" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("injects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainBotnetConfigSource) validateSubBotnet(formats strfmt.Registry) error {

	if err := validate.Required("sub_botnet", "body", m.SubBotnet); err != nil {
		return err
	}

	return nil
}

func (m *DomainBotnetConfigSource) validateSubject(formats strfmt.Registry) error {

	if err := validate.Required("subject", "body", m.Subject); err != nil {
		return err
	}

	return nil
}

func (m *DomainBotnetConfigSource) validateVariables(formats strfmt.Registry) error {

	if err := validate.Required("variables", "body", m.Variables); err != nil {
		return err
	}

	for i := 0; i < len(m.Variables); i++ {
		if swag.IsZero(m.Variables[i]) { // not required
			continue
		}

		if m.Variables[i] != nil {
			if err := m.Variables[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this domain botnet config source based on the context it is used
func (m *DomainBotnetConfigSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInjects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariables(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainBotnetConfigSource) contextValidateActions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Actions); i++ {

		if m.Actions[i] != nil {

			if swag.IsZero(m.Actions[i]) { // not required
				return nil
			}

			if err := m.Actions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("actions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainBotnetConfigSource) contextValidateInjects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Injects); i++ {

		if m.Injects[i] != nil {

			if swag.IsZero(m.Injects[i]) { // not required
				return nil
			}

			if err := m.Injects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("injects" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("injects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainBotnetConfigSource) contextValidateVariables(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Variables); i++ {

		if m.Variables[i] != nil {

			if swag.IsZero(m.Variables[i]) { // not required
				return nil
			}

			if err := m.Variables[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainBotnetConfigSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainBotnetConfigSource) UnmarshalBinary(b []byte) error {
	var res DomainBotnetConfigSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
