// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainChildLink domain child link
//
// swagger:model domain.ChildLink
type DomainChildLink struct {

	// checksum
	// Required: true
	Checksum *string `json:"checksum"`

	// child cid
	// Required: true
	ChildCid *string `json:"child_cid"`

	// child gcid
	ChildGcid string `json:"child_gcid,omitempty"`

	// child of
	// Required: true
	ChildOf *string `json:"child_of"`

	// domains
	Domains []string `json:"domains"`

	// name
	Name string `json:"name,omitempty"`

	// status
	Status string `json:"status,omitempty"`
}

// Validate validates this domain child link
func (m *DomainChildLink) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChecksum(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateChildCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateChildOf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainChildLink) validateChecksum(formats strfmt.Registry) error {

	if err := validate.Required("checksum", "body", m.Checksum); err != nil {
		return err
	}

	return nil
}

func (m *DomainChildLink) validateChildCid(formats strfmt.Registry) error {

	if err := validate.Required("child_cid", "body", m.ChildCid); err != nil {
		return err
	}

	return nil
}

func (m *DomainChildLink) validateChildOf(formats strfmt.Registry) error {

	if err := validate.Required("child_of", "body", m.ChildOf); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain child link based on context it is used
func (m *DomainChildLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainChildLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainChildLink) UnmarshalBinary(b []byte) error {
	var res DomainChildLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
