// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainCreateActionRequest domain create action request
//
// swagger:model domain.CreateActionRequest
type DomainCreateActionRequest struct {

	// The level of detail in which the content will be delivered. It can be either 'standard' or 'enhanced'
	// Required: true
	ContentFormat *string `json:"content_format"`

	// The time interval between the action's triggers. It can be one of the values: 'asap', 'daily' or 'weekly'
	// Required: true
	Frequency *string `json:"frequency"`

	// The address list who will be notified by this action.
	// Required: true
	Recipients []string `json:"recipients"`

	// Whether to periodically trigger the action based on the frequency, even when there are no new matches for the associated monitoring rule
	// Required: true
	TriggerMatchless *bool `json:"trigger_matchless"`

	// The action type. The only type currently supported is 'email'
	// Required: true
	Type *string `json:"type"`
}

// Validate validates this domain create action request
func (m *DomainCreateActionRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContentFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrequency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRecipients(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTriggerMatchless(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainCreateActionRequest) validateContentFormat(formats strfmt.Registry) error {

	if err := validate.Required("content_format", "body", m.ContentFormat); err != nil {
		return err
	}

	return nil
}

func (m *DomainCreateActionRequest) validateFrequency(formats strfmt.Registry) error {

	if err := validate.Required("frequency", "body", m.Frequency); err != nil {
		return err
	}

	return nil
}

func (m *DomainCreateActionRequest) validateRecipients(formats strfmt.Registry) error {

	if err := validate.Required("recipients", "body", m.Recipients); err != nil {
		return err
	}

	return nil
}

func (m *DomainCreateActionRequest) validateTriggerMatchless(formats strfmt.Registry) error {

	if err := validate.Required("trigger_matchless", "body", m.TriggerMatchless); err != nil {
		return err
	}

	return nil
}

func (m *DomainCreateActionRequest) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain create action request based on context it is used
func (m *DomainCreateActionRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainCreateActionRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainCreateActionRequest) UnmarshalBinary(b []byte) error {
	var res DomainCreateActionRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
