// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainDDOSTargetDetails domain d d o s target details
//
// swagger:model domain.DDOSTargetDetails
type DomainDDOSTargetDetails struct {

	// The autonomous system number of the target
	// Required: true
	Asn *int32 `json:"asn"`

	// The autonomous system name of the target
	// Required: true
	AsnName *string `json:"asn_name"`

	// The CIDR of the IP address
	// Required: true
	Cidr *string `json:"cidr"`

	// The target's city
	// Required: true
	City *string `json:"city"`

	// The name of the company who has registered the IP address
	// Required: true
	CompanyName *string `json:"company_name"`

	// The connection type of the target
	// Required: true
	ConnectionType *string `json:"connection_type"`

	// The target's country
	// Required: true
	Country *string `json:"country"`

	// country code
	// Required: true
	CountryCode *string `json:"country_code"`

	// The passive DNS of the target
	// Required: true
	Pdns []string `json:"pdns"`

	// The reverse DNS hostname of the target's IP address
	// Required: true
	Rdns *string `json:"rdns"`
}

// Validate validates this domain d d o s target details
func (m *DomainDDOSTargetDetails) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAsn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAsnName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCidr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompanyName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectionType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCountry(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCountryCode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePdns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRdns(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainDDOSTargetDetails) validateAsn(formats strfmt.Registry) error {

	if err := validate.Required("asn", "body", m.Asn); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateAsnName(formats strfmt.Registry) error {

	if err := validate.Required("asn_name", "body", m.AsnName); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateCidr(formats strfmt.Registry) error {

	if err := validate.Required("cidr", "body", m.Cidr); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateCity(formats strfmt.Registry) error {

	if err := validate.Required("city", "body", m.City); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateCompanyName(formats strfmt.Registry) error {

	if err := validate.Required("company_name", "body", m.CompanyName); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateConnectionType(formats strfmt.Registry) error {

	if err := validate.Required("connection_type", "body", m.ConnectionType); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateCountry(formats strfmt.Registry) error {

	if err := validate.Required("country", "body", m.Country); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateCountryCode(formats strfmt.Registry) error {

	if err := validate.Required("country_code", "body", m.CountryCode); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validatePdns(formats strfmt.Registry) error {

	if err := validate.Required("pdns", "body", m.Pdns); err != nil {
		return err
	}

	return nil
}

func (m *DomainDDOSTargetDetails) validateRdns(formats strfmt.Registry) error {

	if err := validate.Required("rdns", "body", m.Rdns); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain d d o s target details based on context it is used
func (m *DomainDDOSTargetDetails) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainDDOSTargetDetails) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainDDOSTargetDetails) UnmarshalBinary(b []byte) error {
	var res DomainDDOSTargetDetails
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
