// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainDiscoverAPIAccount Represents information about an account.
//
// swagger:model domain.DiscoverAPIAccount
type DomainDiscoverAPIAccount struct {

	// The account's name (Domain\Username or Hostname\Username).
	AccountName string `json:"account_name,omitempty"`

	// The type of the account (Local or Domain).
	AccountType string `json:"account_type,omitempty"`

	// Whether the account has administrator privileges (Yes, No, or Unknown).
	AdminPrivileges string `json:"admin_privileges,omitempty"`

	// The account's customer ID.
	// Required: true
	Cid *string `json:"cid"`

	// The first time the account was seen successfully logging in to your environment.
	FirstSeenTimestamp string `json:"first_seen_timestamp,omitempty"`

	// The unique ID of the account.
	// Required: true
	ID *string `json:"id"`

	// The hostname of the asset on which the account last made a failed login.
	LastFailedLoginHostname string `json:"last_failed_login_hostname,omitempty"`

	// The date and time of the account's most recent failed login.
	LastFailedLoginTimestamp string `json:"last_failed_login_timestamp,omitempty"`

	// The type of the account's most recent failed login. <ul><li>Interactive</li><li>Network</li><li>Batch</li><li>Service</li><li>Unlock</li><li>Network cleartext</li><li>New credentials</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
	LastFailedLoginType string `json:"last_failed_login_type,omitempty"`

	// The name of the city where the asset is located on which the account last successfully logged in.
	LastSuccessfulLoginHostCity string `json:"last_successful_login_host_city,omitempty"`

	// The name of the country where the asset is located on which the account last successfully logged in.
	LastSuccessfulLoginHostCountry string `json:"last_successful_login_host_country,omitempty"`

	// The hostname of the asset on which the account last successfully logged in.
	LastSuccessfulLoginHostname string `json:"last_successful_login_hostname,omitempty"`

	// The remote IP address of the asset on which the account last successfully logged in.
	LastSuccessfulLoginRemoteIP string `json:"last_successful_login_remote_ip,omitempty"`

	// The date and time of the account's most recent successful login.
	LastSuccessfulLoginTimestamp string `json:"last_successful_login_timestamp,omitempty"`

	// The type of the account's most recent successful login. <ul><li>Interactive</li><li>Service</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
	LastSuccessfulLoginType string `json:"last_successful_login_type,omitempty"`

	// Whether the account has local administrator privileges (Yes, No).
	LocalAdminPrivileges string `json:"local_admin_privileges,omitempty"`

	// The domain of the asset the account successfully logged in to.
	LoginDomain string `json:"login_domain,omitempty"`

	// The most recent date and time the account's password was changed.
	PasswordLastSetTimestamp string `json:"password_last_set_timestamp,omitempty"`

	// The account's security identifier on Windows assets.
	UserSid string `json:"user_sid,omitempty"`

	// The account's username.
	Username string `json:"username,omitempty"`
}

// Validate validates this domain discover API account
func (m *DomainDiscoverAPIAccount) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainDiscoverAPIAccount) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainDiscoverAPIAccount) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain discover API account based on context it is used
func (m *DomainDiscoverAPIAccount) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainDiscoverAPIAccount) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainDiscoverAPIAccount) UnmarshalBinary(b []byte) error {
	var res DomainDiscoverAPIAccount
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
