// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainDiscoverAPIApplication Represents information about an application.
//
// swagger:model domain.DiscoverAPIApplication
type DomainDiscoverAPIApplication struct {

	// Represents the application architectures (x86 / x64).
	Architectures []string `json:"architectures"`

	// The category of the application.
	Category string `json:"category,omitempty"`

	// The customer ID of this application.
	// Required: true
	Cid *string `json:"cid"`

	// Timestamp when this application was first seen by the cloud.
	FirstSeenTimestamp string `json:"first_seen_timestamp,omitempty"`

	// The user defined groups this application is part of.
	Groups []string `json:"groups"`

	// The host on which an application is installed and/or used.
	Host *DomainDiscoverAPIApplicationHost `json:"host,omitempty"`

	// The unique ID for the application.
	// Required: true
	ID *string `json:"id"`

	// The file paths where the application is installed on the host. Or the locations of the executables.
	InstallationPaths []string `json:"installation_paths"`

	// Timestamp when the application was installed on the host. We might not have this data.
	InstallationTimestamp string `json:"installation_timestamp,omitempty"`

	// Whether or not the application is normalized
	IsNormalized bool `json:"is_normalized,omitempty"`

	// Whether or not the application is suspicious
	IsSuspicious bool `json:"is_suspicious,omitempty"`

	// Timestamp when this application was last updated (something changed in the application or in the host data).
	LastUpdatedTimestamp string `json:"last_updated_timestamp,omitempty"`

	// The file hash that was last used for this application.
	LastUsedFileHash string `json:"last_used_file_hash,omitempty"`

	// The file name that was last used for this application.
	LastUsedFileName string `json:"last_used_file_name,omitempty"`

	// Timestamp when this application was last used.
	LastUsedTimestamp string `json:"last_used_timestamp,omitempty"`

	// The username of the user that last used this application.
	LastUsedUserName string `json:"last_used_user_name,omitempty"`

	// The user SID of the last user that used this application.
	LastUsedUserSid string `json:"last_used_user_sid,omitempty"`

	// The name of the application.
	Name string `json:"name,omitempty"`

	// The combined field on which we will be able to group by app.
	NameVendor string `json:"name_vendor,omitempty"`

	// The combined field on which we will be able to group by app + version.
	NameVendorVersion string `json:"name_vendor_version,omitempty"`

	// The name the application's vendor.
	Vendor string `json:"vendor,omitempty"`

	// The version of the application.
	Version string `json:"version,omitempty"`

	// The version scheme of the application.
	VersioningScheme string `json:"versioning_scheme,omitempty"`
}

// Validate validates this domain discover API application
func (m *DomainDiscoverAPIApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHost(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainDiscoverAPIApplication) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainDiscoverAPIApplication) validateHost(formats strfmt.Registry) error {
	if swag.IsZero(m.Host) { // not required
		return nil
	}

	if m.Host != nil {
		if err := m.Host.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("host")
			}
			return err
		}
	}

	return nil
}

func (m *DomainDiscoverAPIApplication) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain discover API application based on the context it is used
func (m *DomainDiscoverAPIApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHost(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainDiscoverAPIApplication) contextValidateHost(ctx context.Context, formats strfmt.Registry) error {

	if m.Host != nil {

		if swag.IsZero(m.Host) { // not required
			return nil
		}

		if err := m.Host.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("host")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("host")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainDiscoverAPIApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainDiscoverAPIApplication) UnmarshalBinary(b []byte) error {
	var res DomainDiscoverAPIApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
