// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// DomainDiscoverAPILogin Represents information about a successful or a failed login.
//
// swagger:model domain.DiscoverAPILogin
type DomainDiscoverAPILogin struct {

	// The ID of the account that made the login.
	AccountID string `json:"account_id,omitempty"`

	// The name of the account that made the login (Domain\Username or Hostname\Username).
	AccountName string `json:"account_name,omitempty"`

	// The type of the account that made the login.
	AccountType string `json:"account_type,omitempty"`

	// Whether the account that made the login has administrator privileges (Yes, No, or Unknown).
	AdminPrivileges string `json:"admin_privileges,omitempty"`

	// A login represents an aggregation of login attempts made in a window of time (1-hour window for logins in the past day, or 24-hour window for logins older than a day).
	AggregationTimeInterval string `json:"aggregation_time_interval,omitempty"`

	// The agent ID of the Falcon sensor installed on the asset where the login took place.
	Aid string `json:"aid,omitempty"`

	// The customer ID where login took place.
	Cid string `json:"cid,omitempty"`

	// The description of the reason why the login failed, if login_status="Failed".<ul><li>There are currently no login servers available to service the login request.</li><li>User login with misspelled or bad user account</li><li>User login with misspelled or bad password</li><li>This is either due to a bad username or authentication information</li><li>Unknown user name or bad password.</li><li>User login outside authorized hours</li><li>User login from unauthorized workstation</li><li>User login with expired password</li><li>User login to account disabled by administrator</li><li>Indicates the Sam Server was in the wrong state to perform the desired operation.</li><li>Clocks between DC and other computer too far out of sync</li><li>The user has not been granted the requested login type (aka login right) at this machine</li><li>The login request failed because the trust relationship between the primary domain and the trusted domain failed.</li><li>An attempt was made to login, but the Netlogon service was not started.</li><li>User login with expired account</li><li>User is required to change password at next login</li><li>Evidently a bug in Windows and not a risk</li><li>User login with account locked</li><li>Failure Reason: An Error occurred during Login</li><li>Login Failure: The machine you are logging in to is protected by an authentication firewall. The specified account is not allowed to authenticate to the machine.</li><li>Status OK.</li><li>Invalid password entered</li></ul>
	FailureDescription string `json:"failure_description,omitempty"`

	// The name of the city where the asset is located where the login took place.
	HostCity string `json:"host_city,omitempty"`

	// The name of the country where the asset is located on which the login took place.
	HostCountry string `json:"host_country,omitempty"`

	// The unique ID of the asset where the login took place.
	HostID string `json:"host_id,omitempty"`

	// The hostname of the host where the login took place.
	Hostname string `json:"hostname,omitempty"`

	// The unique ID of the login.
	ID string `json:"id,omitempty"`

	// Whether the failed login is considered suspicious based on criteria including login failures and locations (true or false).
	IsSuspicious bool `json:"is_suspicious,omitempty"`

	// Whether the account has local administrator privileges (Yes, No).
	LocalAdminPrivileges string `json:"local_admin_privileges,omitempty"`

	// The external IP address of the asset where the login took place.
	LocalIP string `json:"local_ip,omitempty"`

	// The domain of the asset where the login took place.
	LoginDomain string `json:"login_domain,omitempty"`

	// Number of times a login attempt happened in the specified aggregation time interval for this login (1-hour window for logins in the past day, or 24-hour window for logins older than a day).
	LoginEventCount int64 `json:"login_event_count,omitempty"`

	// The status of the login (Successful or Failed).
	LoginStatus string `json:"login_status,omitempty"`

	// The date and time of the most recent attempt in the login.
	LoginTimestamp string `json:"login_timestamp,omitempty"`

	// The type of the login.
	//
	// For successful logins: <ul><li>Interactive</li><li>Service</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
	// For failed logins: <ul><li>Interactive</li><li>Network</li><li>Batch</li><li>Service</li><li>Unlock</li><li>Network cleartext</li><li>New credentials</li><li>Terminal server</li><li>Cached credentials</li><li>Auditing</li></ul>
	LoginType string `json:"login_type,omitempty"`

	// The remote IP address where the login was initiated.
	RemoteIP string `json:"remote_ip,omitempty"`

	// The security identifier of the account on a Windows asset that made the login.
	UserSid string `json:"user_sid,omitempty"`

	// The username of the account that made the login.
	Username string `json:"username,omitempty"`
}

// Validate validates this domain discover API login
func (m *DomainDiscoverAPILogin) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this domain discover API login based on context it is used
func (m *DomainDiscoverAPILogin) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainDiscoverAPILogin) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainDiscoverAPILogin) UnmarshalBinary(b []byte) error {
	var res DomainDiscoverAPILogin
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
