// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainEnvironmentScore domain environment score
//
// swagger:model domain.EnvironmentScore
type DomainEnvironmentScore struct {

	// adjusted score
	// Required: true
	AdjustedScore *int32 `json:"adjusted_score"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// id
	ID string `json:"id,omitempty"`

	// score
	// Required: true
	Score *int32 `json:"score"`

	// timestamp
	// Required: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp"`
}

// Validate validates this domain environment score
func (m *DomainEnvironmentScore) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAdjustedScore(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScore(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainEnvironmentScore) validateAdjustedScore(formats strfmt.Registry) error {

	if err := validate.Required("adjusted_score", "body", m.AdjustedScore); err != nil {
		return err
	}

	return nil
}

func (m *DomainEnvironmentScore) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainEnvironmentScore) validateScore(formats strfmt.Registry) error {

	if err := validate.Required("score", "body", m.Score); err != nil {
		return err
	}

	return nil
}

func (m *DomainEnvironmentScore) validateTimestamp(formats strfmt.Registry) error {

	if err := validate.Required("timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain environment score based on context it is used
func (m *DomainEnvironmentScore) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainEnvironmentScore) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainEnvironmentScore) UnmarshalBinary(b []byte) error {
	var res DomainEnvironmentScore
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
