// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainEventHistogram domain event histogram
//
// swagger:model domain.EventHistogram
type DomainEventHistogram struct {

	// count
	// Required: true
	Count *int32 `json:"count"`

	// has detect
	// Required: true
	HasDetect *bool `json:"has_detect"`

	// has overwatch
	// Required: true
	HasOverwatch *bool `json:"has_overwatch"`

	// has prevented
	// Required: true
	HasPrevented *bool `json:"has_prevented"`

	// timestamp max
	// Required: true
	TimestampMax *int64 `json:"timestamp_max"`

	// timestamp min
	// Required: true
	TimestampMin *int64 `json:"timestamp_min"`
}

// Validate validates this domain event histogram
func (m *DomainEventHistogram) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHasDetect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHasOverwatch(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHasPrevented(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestampMax(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestampMin(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainEventHistogram) validateCount(formats strfmt.Registry) error {

	if err := validate.Required("count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *DomainEventHistogram) validateHasDetect(formats strfmt.Registry) error {

	if err := validate.Required("has_detect", "body", m.HasDetect); err != nil {
		return err
	}

	return nil
}

func (m *DomainEventHistogram) validateHasOverwatch(formats strfmt.Registry) error {

	if err := validate.Required("has_overwatch", "body", m.HasOverwatch); err != nil {
		return err
	}

	return nil
}

func (m *DomainEventHistogram) validateHasPrevented(formats strfmt.Registry) error {

	if err := validate.Required("has_prevented", "body", m.HasPrevented); err != nil {
		return err
	}

	return nil
}

func (m *DomainEventHistogram) validateTimestampMax(formats strfmt.Registry) error {

	if err := validate.Required("timestamp_max", "body", m.TimestampMax); err != nil {
		return err
	}

	return nil
}

func (m *DomainEventHistogram) validateTimestampMin(formats strfmt.Registry) error {

	if err := validate.Required("timestamp_min", "body", m.TimestampMin); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain event histogram based on context it is used
func (m *DomainEventHistogram) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainEventHistogram) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainEventHistogram) UnmarshalBinary(b []byte) error {
	var res DomainEventHistogram
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
