// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainExposedDataRecordFinancialV1 domain exposed data record financial v1
//
// swagger:model domain.ExposedDataRecordFinancialV1
type DomainExposedDataRecordFinancialV1 struct {

	// bank account
	// Required: true
	BankAccount *string `json:"bank_account"`

	// credit card
	// Required: true
	CreditCard *string `json:"credit_card"`

	// crypto currency addresses
	// Required: true
	CryptoCurrencyAddresses []string `json:"crypto_currency_addresses"`
}

// Validate validates this domain exposed data record financial v1
func (m *DomainExposedDataRecordFinancialV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBankAccount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreditCard(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCryptoCurrencyAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainExposedDataRecordFinancialV1) validateBankAccount(formats strfmt.Registry) error {

	if err := validate.Required("bank_account", "body", m.BankAccount); err != nil {
		return err
	}

	return nil
}

func (m *DomainExposedDataRecordFinancialV1) validateCreditCard(formats strfmt.Registry) error {

	if err := validate.Required("credit_card", "body", m.CreditCard); err != nil {
		return err
	}

	return nil
}

func (m *DomainExposedDataRecordFinancialV1) validateCryptoCurrencyAddresses(formats strfmt.Registry) error {

	if err := validate.Required("crypto_currency_addresses", "body", m.CryptoCurrencyAddresses); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain exposed data record financial v1 based on context it is used
func (m *DomainExposedDataRecordFinancialV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainExposedDataRecordFinancialV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainExposedDataRecordFinancialV1) UnmarshalBinary(b []byte) error {
	var res DomainExposedDataRecordFinancialV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
