// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainLastScheduledExecution domain last scheduled execution
//
// swagger:model domain.LastScheduledExecution
type DomainLastScheduledExecution struct {

	// id
	// Required: true
	ID *string `json:"id"`

	// search window end
	// Format: date-time
	SearchWindowEnd strfmt.DateTime `json:"search_window_end,omitempty"`

	// search window start
	// Format: date-time
	SearchWindowStart strfmt.DateTime `json:"search_window_start,omitempty"`

	// status display
	// Required: true
	StatusDisplay *string `json:"status_display"`
}

// Validate validates this domain last scheduled execution
func (m *DomainLastScheduledExecution) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSearchWindowEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSearchWindowStart(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusDisplay(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainLastScheduledExecution) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainLastScheduledExecution) validateSearchWindowEnd(formats strfmt.Registry) error {
	if swag.IsZero(m.SearchWindowEnd) { // not required
		return nil
	}

	if err := validate.FormatOf("search_window_end", "body", "date-time", m.SearchWindowEnd.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainLastScheduledExecution) validateSearchWindowStart(formats strfmt.Registry) error {
	if swag.IsZero(m.SearchWindowStart) { // not required
		return nil
	}

	if err := validate.FormatOf("search_window_start", "body", "date-time", m.SearchWindowStart.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainLastScheduledExecution) validateStatusDisplay(formats strfmt.Registry) error {

	if err := validate.Required("status_display", "body", m.StatusDisplay); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain last scheduled execution based on context it is used
func (m *DomainLastScheduledExecution) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainLastScheduledExecution) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainLastScheduledExecution) UnmarshalBinary(b []byte) error {
	var res DomainLastScheduledExecution
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
