// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainLaunchExportJobRequestV1 domain launch export job request v1
//
// swagger:model domain.LaunchExportJobRequestV1
type DomainLaunchExportJobRequestV1 struct {

	// The entity type. This can be one of: [`notification-exposed-data-record`]
	// Required: true
	Entity *string `json:"entity"`

	// The file type of the export. This can be one of: [`json`, `csv`]
	// Required: true
	ExportType *string `json:"export_type"`

	// FQL query to filter entities by. Possible filter properties depend on the entity type.
	// Required: true
	Filter *string `json:"filter"`

	// If set to true (default), the field names in the exported file will resemble the table header in the UI (e.g. "Hash type"), otherwise the API level field names will be used (e.g. "hash_type")
	// Required: true
	HumanReadable *bool `json:"human_readable"`

	// Possible order by fields: created_timestamp, last_updated_timestamp. Ex: 'last_updated_timestamp|desc'
	Sort string `json:"sort,omitempty"`
}

// Validate validates this domain launch export job request v1
func (m *DomainLaunchExportJobRequestV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEntity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHumanReadable(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainLaunchExportJobRequestV1) validateEntity(formats strfmt.Registry) error {

	if err := validate.Required("entity", "body", m.Entity); err != nil {
		return err
	}

	return nil
}

func (m *DomainLaunchExportJobRequestV1) validateExportType(formats strfmt.Registry) error {

	if err := validate.Required("export_type", "body", m.ExportType); err != nil {
		return err
	}

	return nil
}

func (m *DomainLaunchExportJobRequestV1) validateFilter(formats strfmt.Registry) error {

	if err := validate.Required("filter", "body", m.Filter); err != nil {
		return err
	}

	return nil
}

func (m *DomainLaunchExportJobRequestV1) validateHumanReadable(formats strfmt.Registry) error {

	if err := validate.Required("human_readable", "body", m.HumanReadable); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain launch export job request v1 based on context it is used
func (m *DomainLaunchExportJobRequestV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainLaunchExportJobRequestV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainLaunchExportJobRequestV1) UnmarshalBinary(b []byte) error {
	var res DomainLaunchExportJobRequestV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
