// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainQueuedSessionCommand domain queued session command
//
// swagger:model domain.QueuedSessionCommand
type DomainQueuedSessionCommand struct {

	// base command
	// Required: true
	BaseCommand *string `json:"base_command"`

	// cloud request id
	// Required: true
	CloudRequestID *string `json:"cloud_request_id"`

	// command string
	// Required: true
	CommandString *string `json:"command_string"`

	// created at
	// Required: true
	// Format: date-time
	CreatedAt *strfmt.DateTime `json:"created_at"`

	// deleted at
	// Required: true
	// Format: date-time
	DeletedAt *strfmt.DateTime `json:"deleted_at"`

	// status
	// Required: true
	Status *string `json:"status"`

	// status text
	StatusText string `json:"status_text,omitempty"`

	// updated at
	// Required: true
	// Format: date-time
	UpdatedAt *strfmt.DateTime `json:"updated_at"`
}

// Validate validates this domain queued session command
func (m *DomainQueuedSessionCommand) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBaseCommand(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudRequestID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCommandString(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeletedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainQueuedSessionCommand) validateBaseCommand(formats strfmt.Registry) error {

	if err := validate.Required("base_command", "body", m.BaseCommand); err != nil {
		return err
	}

	return nil
}

func (m *DomainQueuedSessionCommand) validateCloudRequestID(formats strfmt.Registry) error {

	if err := validate.Required("cloud_request_id", "body", m.CloudRequestID); err != nil {
		return err
	}

	return nil
}

func (m *DomainQueuedSessionCommand) validateCommandString(formats strfmt.Registry) error {

	if err := validate.Required("command_string", "body", m.CommandString); err != nil {
		return err
	}

	return nil
}

func (m *DomainQueuedSessionCommand) validateCreatedAt(formats strfmt.Registry) error {

	if err := validate.Required("created_at", "body", m.CreatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainQueuedSessionCommand) validateDeletedAt(formats strfmt.Registry) error {

	if err := validate.Required("deleted_at", "body", m.DeletedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("deleted_at", "body", "date-time", m.DeletedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainQueuedSessionCommand) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DomainQueuedSessionCommand) validateUpdatedAt(formats strfmt.Registry) error {

	if err := validate.Required("updated_at", "body", m.UpdatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain queued session command based on context it is used
func (m *DomainQueuedSessionCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainQueuedSessionCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainQueuedSessionCommand) UnmarshalBinary(b []byte) error {
	var res DomainQueuedSessionCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
