// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainReportExecutionSummaryV1 domain report execution summary v1
//
// swagger:model domain.ReportExecutionSummaryV1
type DomainReportExecutionSummaryV1 struct {

	// execution metadata
	// Required: true
	ExecutionMetadata *DomainExecutionMetadataSummary `json:"execution_metadata"`

	// id
	// Required: true
	ID *string `json:"id"`

	// last updated on
	// Required: true
	// Format: date-time
	LastUpdatedOn *strfmt.DateTime `json:"last_updated_on"`

	// report file reference
	ReportFileReference string `json:"report_file_reference,omitempty"`

	// result metadata
	ResultMetadata *DomainResultMetadata `json:"result_metadata,omitempty"`

	// status
	// Required: true
	Status *string `json:"status"`

	// status display
	// Required: true
	StatusDisplay *string `json:"status_display"`

	// status msg
	// Required: true
	StatusMsg *string `json:"status_msg"`
}

// Validate validates this domain report execution summary v1
func (m *DomainReportExecutionSummaryV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExecutionMetadata(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdatedOn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResultMetadata(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusDisplay(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusMsg(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainReportExecutionSummaryV1) validateExecutionMetadata(formats strfmt.Registry) error {

	if err := validate.Required("execution_metadata", "body", m.ExecutionMetadata); err != nil {
		return err
	}

	if m.ExecutionMetadata != nil {
		if err := m.ExecutionMetadata.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("execution_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("execution_metadata")
			}
			return err
		}
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) validateLastUpdatedOn(formats strfmt.Registry) error {

	if err := validate.Required("last_updated_on", "body", m.LastUpdatedOn); err != nil {
		return err
	}

	if err := validate.FormatOf("last_updated_on", "body", "date-time", m.LastUpdatedOn.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) validateResultMetadata(formats strfmt.Registry) error {
	if swag.IsZero(m.ResultMetadata) { // not required
		return nil
	}

	if m.ResultMetadata != nil {
		if err := m.ResultMetadata.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("result_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("result_metadata")
			}
			return err
		}
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) validateStatusDisplay(formats strfmt.Registry) error {

	if err := validate.Required("status_display", "body", m.StatusDisplay); err != nil {
		return err
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) validateStatusMsg(formats strfmt.Registry) error {

	if err := validate.Required("status_msg", "body", m.StatusMsg); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this domain report execution summary v1 based on the context it is used
func (m *DomainReportExecutionSummaryV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExecutionMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResultMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainReportExecutionSummaryV1) contextValidateExecutionMetadata(ctx context.Context, formats strfmt.Registry) error {

	if m.ExecutionMetadata != nil {

		if err := m.ExecutionMetadata.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("execution_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("execution_metadata")
			}
			return err
		}
	}

	return nil
}

func (m *DomainReportExecutionSummaryV1) contextValidateResultMetadata(ctx context.Context, formats strfmt.Registry) error {

	if m.ResultMetadata != nil {

		if swag.IsZero(m.ResultMetadata) { // not required
			return nil
		}

		if err := m.ResultMetadata.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("result_metadata")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("result_metadata")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainReportExecutionSummaryV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainReportExecutionSummaryV1) UnmarshalBinary(b []byte) error {
	var res DomainReportExecutionSummaryV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
