// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainSensorInstallerV1 domain sensor installer v1
//
// swagger:model domain.SensorInstallerV1
type DomainSensorInstallerV1 struct {

	// installer description
	// Required: true
	Description *string `json:"description"`

	// file size
	// Required: true
	FileSize *int32 `json:"file_size"`

	// file type
	// Required: true
	FileType *string `json:"file_type"`

	// installer file name
	// Required: true
	Name *string `json:"name"`

	// os
	// Required: true
	Os *string `json:"os"`

	// os version
	// Required: true
	OsVersion *string `json:"os_version"`

	// supported platform
	// Required: true
	Platform *string `json:"platform"`

	// release date
	// Required: true
	// Format: date-time
	ReleaseDate *strfmt.DateTime `json:"release_date"`

	// sha256
	// Required: true
	Sha256 *string `json:"sha256"`

	// version of the installer
	// Required: true
	Version *string `json:"version"`
}

// Validate validates this domain sensor installer v1
func (m *DomainSensorInstallerV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFileSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFileType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatform(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateReleaseDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSha256(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainSensorInstallerV1) validateDescription(formats strfmt.Registry) error {

	if err := validate.Required("description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateFileSize(formats strfmt.Registry) error {

	if err := validate.Required("file_size", "body", m.FileSize); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateFileType(formats strfmt.Registry) error {

	if err := validate.Required("file_type", "body", m.FileType); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateOs(formats strfmt.Registry) error {

	if err := validate.Required("os", "body", m.Os); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateOsVersion(formats strfmt.Registry) error {

	if err := validate.Required("os_version", "body", m.OsVersion); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validatePlatform(formats strfmt.Registry) error {

	if err := validate.Required("platform", "body", m.Platform); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateReleaseDate(formats strfmt.Registry) error {

	if err := validate.Required("release_date", "body", m.ReleaseDate); err != nil {
		return err
	}

	if err := validate.FormatOf("release_date", "body", "date-time", m.ReleaseDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateSha256(formats strfmt.Registry) error {

	if err := validate.Required("sha256", "body", m.Sha256); err != nil {
		return err
	}

	return nil
}

func (m *DomainSensorInstallerV1) validateVersion(formats strfmt.Registry) error {

	if err := validate.Required("version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain sensor installer v1 based on context it is used
func (m *DomainSensorInstallerV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainSensorInstallerV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainSensorInstallerV1) UnmarshalBinary(b []byte) error {
	var res DomainSensorInstallerV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
