// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainTweetSource domain tweet source
//
// swagger:model domain.TweetSource
type DomainTweetSource struct {

	// The username of the tweet's author
	// Required: true
	AuthorName *string `json:"author_name"`

	// The language of the tweet
	// Required: true
	Language *string `json:"language"`

	// Populated for legacy source events
	LegacySource DomainTweetSourceLegacySource `json:"legacy_source,omitempty"`

	// The link to the tweet
	// Required: true
	SourceLink *string `json:"source_link"`

	// The tweet ID
	// Required: true
	TweetID *int64 `json:"tweet_id"`
}

// Validate validates this domain tweet source
func (m *DomainTweetSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthorName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLanguage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSourceLink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTweetID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainTweetSource) validateAuthorName(formats strfmt.Registry) error {

	if err := validate.Required("author_name", "body", m.AuthorName); err != nil {
		return err
	}

	return nil
}

func (m *DomainTweetSource) validateLanguage(formats strfmt.Registry) error {

	if err := validate.Required("language", "body", m.Language); err != nil {
		return err
	}

	return nil
}

func (m *DomainTweetSource) validateSourceLink(formats strfmt.Registry) error {

	if err := validate.Required("source_link", "body", m.SourceLink); err != nil {
		return err
	}

	return nil
}

func (m *DomainTweetSource) validateTweetID(formats strfmt.Registry) error {

	if err := validate.Required("tweet_id", "body", m.TweetID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain tweet source based on context it is used
func (m *DomainTweetSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainTweetSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainTweetSource) UnmarshalBinary(b []byte) error {
	var res DomainTweetSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
