// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainUserAction Action to be performed
//
// swagger:model domain.UserAction
type DomainUserAction struct {

	// Action name
	// Required: true
	// Enum: [reset_password reset_2fa]
	ActionName *string `json:"action_name"`

	// Value for action, if any
	ActionValue string `json:"action_value,omitempty"`
}

// Validate validates this domain user action
func (m *DomainUserAction) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActionName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var domainUserActionTypeActionNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["reset_password","reset_2fa"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		domainUserActionTypeActionNamePropEnum = append(domainUserActionTypeActionNamePropEnum, v)
	}
}

const (

	// DomainUserActionActionNameResetPassword captures enum value "reset_password"
	DomainUserActionActionNameResetPassword string = "reset_password"

	// DomainUserActionActionNameReset2fa captures enum value "reset_2fa"
	DomainUserActionActionNameReset2fa string = "reset_2fa"
)

// prop value enum
func (m *DomainUserAction) validateActionNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, domainUserActionTypeActionNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DomainUserAction) validateActionName(formats strfmt.Registry) error {

	if err := validate.Required("action_name", "body", m.ActionName); err != nil {
		return err
	}

	// value enum
	if err := m.validateActionNameEnum("action_name", "body", *m.ActionName); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain user action based on context it is used
func (m *DomainUserAction) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainUserAction) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainUserAction) UnmarshalBinary(b []byte) error {
	var res DomainUserAction
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
