// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainUserGrants domain user grants
//
// swagger:model domain.UserGrants
type DomainUserGrants struct {

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// cid group id
	CidGroupID string `json:"cid_group_id,omitempty"`

	// cid group name
	CidGroupName string `json:"cid_group_name,omitempty"`

	// grant type
	// Required: true
	GrantType *string `json:"grant_type"`

	// parent cid
	ParentCid string `json:"parent_cid,omitempty"`

	// role id
	// Required: true
	RoleID *string `json:"role_id"`

	// role name
	// Required: true
	RoleName *string `json:"role_name"`

	// user group id
	UserGroupID string `json:"user_group_id,omitempty"`

	// user group name
	UserGroupName string `json:"user_group_name,omitempty"`

	// uuid
	// Required: true
	UUID *string `json:"uuid"`
}

// Validate validates this domain user grants
func (m *DomainUserGrants) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGrantType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRoleID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRoleName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainUserGrants) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *DomainUserGrants) validateGrantType(formats strfmt.Registry) error {

	if err := validate.Required("grant_type", "body", m.GrantType); err != nil {
		return err
	}

	return nil
}

func (m *DomainUserGrants) validateRoleID(formats strfmt.Registry) error {

	if err := validate.Required("role_id", "body", m.RoleID); err != nil {
		return err
	}

	return nil
}

func (m *DomainUserGrants) validateRoleName(formats strfmt.Registry) error {

	if err := validate.Required("role_name", "body", m.RoleName); err != nil {
		return err
	}

	return nil
}

func (m *DomainUserGrants) validateUUID(formats strfmt.Registry) error {

	if err := validate.Required("uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this domain user grants based on context it is used
func (m *DomainUserGrants) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DomainUserGrants) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainUserGrants) UnmarshalBinary(b []byte) error {
	var res DomainUserGrants
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
