// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DomainVulnerability domain vulnerability
//
// swagger:model domain.Vulnerability
type DomainVulnerability struct {

	// List of products affected by vulnerability, specifying product and vendor
	AffectedProducts []*DomainVulnerabilityAffectedProduct `json:"affected_products"`

	// Vulnerability community identifiers, which is usually populated for the most popular vulnerabilities
	CommunityIdentifiers []string `json:"community_identifiers"`

	// CVE ID number with four or more digits in the sequence number portion of the ID, examples: CVE-1999-0067, CVE-2014-12345, CVE-2016-7654321
	// Required: true
	Cve *string `json:"cve"`

	// Vulnerability severity score, according to Common Vulnerability Scoring System V2
	CvssV2Base string `json:"cvss_v2_base,omitempty"`

	// Vulnerability severity score, according to Common Vulnerability Scoring System V3
	CvssV3Base string `json:"cvss_v3_base,omitempty"`

	// Text description of the vulnerability
	Description string `json:"description,omitempty"`

	// Exploit status of vulnerability, one of: unproven, available, easilyaccessible, activelyused
	ExploitStatus string `json:"exploit_status,omitempty"`

	// legacy field, not populated
	Name string `json:"name,omitempty"`

	// Date when the vulnerability was published
	PublishDate string `json:"publish_date,omitempty"`

	// Threat actors that exploits vulnerability
	RelatedActors []*DomainVulnerabilityActor `json:"related_actors"`

	// Related finished Intelligence Reports to vulnerability, which usually describes the exploitation or attacks using those
	RelatedReports []*DomainVulnerabilityReport `json:"related_reports"`

	// Malware Families (threats) that are known to be related to the vulnerability
	RelatedThreats []*DomainVulnerabilityRelatedThreat `json:"related_threats"`

	// Severity of the vulnerability, can be empty or one of: LOW, MEDIUM, HIGH, CRITICAL
	Severity string `json:"severity,omitempty"`

	// Date when the vulnerability was last time updated in the CrowdStrike's database
	UpdatedTimestamp string `json:"updated_timestamp,omitempty"`
}

// Validate validates this domain vulnerability
func (m *DomainVulnerability) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAffectedProducts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCve(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelatedActors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelatedReports(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelatedThreats(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainVulnerability) validateAffectedProducts(formats strfmt.Registry) error {
	if swag.IsZero(m.AffectedProducts) { // not required
		return nil
	}

	for i := 0; i < len(m.AffectedProducts); i++ {
		if swag.IsZero(m.AffectedProducts[i]) { // not required
			continue
		}

		if m.AffectedProducts[i] != nil {
			if err := m.AffectedProducts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("affected_products" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("affected_products" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainVulnerability) validateCve(formats strfmt.Registry) error {

	if err := validate.Required("cve", "body", m.Cve); err != nil {
		return err
	}

	return nil
}

func (m *DomainVulnerability) validateRelatedActors(formats strfmt.Registry) error {
	if swag.IsZero(m.RelatedActors) { // not required
		return nil
	}

	for i := 0; i < len(m.RelatedActors); i++ {
		if swag.IsZero(m.RelatedActors[i]) { // not required
			continue
		}

		if m.RelatedActors[i] != nil {
			if err := m.RelatedActors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_actors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_actors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainVulnerability) validateRelatedReports(formats strfmt.Registry) error {
	if swag.IsZero(m.RelatedReports) { // not required
		return nil
	}

	for i := 0; i < len(m.RelatedReports); i++ {
		if swag.IsZero(m.RelatedReports[i]) { // not required
			continue
		}

		if m.RelatedReports[i] != nil {
			if err := m.RelatedReports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_reports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainVulnerability) validateRelatedThreats(formats strfmt.Registry) error {
	if swag.IsZero(m.RelatedThreats) { // not required
		return nil
	}

	for i := 0; i < len(m.RelatedThreats); i++ {
		if swag.IsZero(m.RelatedThreats[i]) { // not required
			continue
		}

		if m.RelatedThreats[i] != nil {
			if err := m.RelatedThreats[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_threats" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_threats" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this domain vulnerability based on the context it is used
func (m *DomainVulnerability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAffectedProducts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelatedActors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelatedReports(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelatedThreats(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DomainVulnerability) contextValidateAffectedProducts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AffectedProducts); i++ {

		if m.AffectedProducts[i] != nil {

			if swag.IsZero(m.AffectedProducts[i]) { // not required
				return nil
			}

			if err := m.AffectedProducts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("affected_products" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("affected_products" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainVulnerability) contextValidateRelatedActors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RelatedActors); i++ {

		if m.RelatedActors[i] != nil {

			if swag.IsZero(m.RelatedActors[i]) { // not required
				return nil
			}

			if err := m.RelatedActors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_actors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_actors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainVulnerability) contextValidateRelatedReports(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RelatedReports); i++ {

		if m.RelatedReports[i] != nil {

			if swag.IsZero(m.RelatedReports[i]) { // not required
				return nil
			}

			if err := m.RelatedReports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_reports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_reports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DomainVulnerability) contextValidateRelatedThreats(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RelatedThreats); i++ {

		if m.RelatedThreats[i] != nil {

			if swag.IsZero(m.RelatedThreats[i]) { // not required
				return nil
			}

			if err := m.RelatedThreats[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_threats" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_threats" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DomainVulnerability) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DomainVulnerability) UnmarshalBinary(b []byte) error {
	var res DomainVulnerability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
