// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EmpowerapiRemoteCommandPutFileV1 empowerapi remote command put file v1
//
// swagger:model empowerapi.RemoteCommandPutFileV1
type EmpowerapiRemoteCommandPutFileV1 struct {

	// comments for audit log
	CommentsForAuditLog string `json:"comments_for_audit_log,omitempty"`

	// content
	Content string `json:"content,omitempty"`

	// created by
	CreatedBy string `json:"created_by,omitempty"`

	// created by uuid
	CreatedByUUID string `json:"created_by_uuid,omitempty"`

	// created timestamp
	// Format: date-time
	CreatedTimestamp strfmt.DateTime `json:"created_timestamp,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// file type
	FileType string `json:"file_type,omitempty"`

	// id
	ID string `json:"id,omitempty"`

	// modified by
	ModifiedBy string `json:"modified_by,omitempty"`

	// modified by uuid
	ModifiedByUUID string `json:"modified_by_uuid,omitempty"`

	// modified timestamp
	// Format: date-time
	ModifiedTimestamp strfmt.DateTime `json:"modified_timestamp,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// permission type
	PermissionType string `json:"permission_type,omitempty"`

	// platform
	Platform []string `json:"platform"`

	// run attempt count
	// Required: true
	RunAttemptCount *int64 `json:"run_attempt_count"`

	// run success count
	// Required: true
	RunSuccessCount *int64 `json:"run_success_count"`

	// sha256
	Sha256 string `json:"sha256,omitempty"`

	// size
	Size int64 `json:"size,omitempty"`

	// write access
	WriteAccess bool `json:"write_access,omitempty"`
}

// Validate validates this empowerapi remote command put file v1
func (m *EmpowerapiRemoteCommandPutFileV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModifiedTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRunAttemptCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRunSuccessCount(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EmpowerapiRemoteCommandPutFileV1) validateCreatedTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedTimestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("created_timestamp", "body", "date-time", m.CreatedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *EmpowerapiRemoteCommandPutFileV1) validateModifiedTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.ModifiedTimestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("modified_timestamp", "body", "date-time", m.ModifiedTimestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *EmpowerapiRemoteCommandPutFileV1) validateRunAttemptCount(formats strfmt.Registry) error {

	if err := validate.Required("run_attempt_count", "body", m.RunAttemptCount); err != nil {
		return err
	}

	return nil
}

func (m *EmpowerapiRemoteCommandPutFileV1) validateRunSuccessCount(formats strfmt.Registry) error {

	if err := validate.Required("run_success_count", "body", m.RunSuccessCount); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this empowerapi remote command put file v1 based on context it is used
func (m *EmpowerapiRemoteCommandPutFileV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EmpowerapiRemoteCommandPutFileV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EmpowerapiRemoteCommandPutFileV1) UnmarshalBinary(b []byte) error {
	var res EmpowerapiRemoteCommandPutFileV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
