// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EntitiesODSScanRequest entities o d s scan request
//
// swagger:model entities.ODSScanRequest
type EntitiesODSScanRequest struct {

	// cloud ml level detection
	// Required: true
	CloudMlLevelDetection *int32 `json:"cloud_ml_level_detection"`

	// cloud ml level prevention
	// Required: true
	CloudMlLevelPrevention *int32 `json:"cloud_ml_level_prevention"`

	// cpu priority
	// Required: true
	CPUPriority *int32 `json:"cpu_priority"`

	// description
	// Required: true
	Description *string `json:"description"`

	// endpoint notification
	// Required: true
	EndpointNotification *bool `json:"endpoint_notification"`

	// file paths
	// Required: true
	FilePaths []string `json:"file_paths"`

	// host groups
	// Required: true
	HostGroups []string `json:"host_groups"`

	// hosts
	// Required: true
	Hosts []string `json:"hosts"`

	// initiated from
	// Required: true
	InitiatedFrom *string `json:"initiated_from"`

	// max duration
	// Required: true
	MaxDuration *int32 `json:"max_duration"`

	// max file size
	// Required: true
	MaxFileSize *int32 `json:"max_file_size"`

	// pause duration
	// Required: true
	PauseDuration *int32 `json:"pause_duration"`

	// quarantine
	// Required: true
	Quarantine *bool `json:"quarantine"`

	// scan exclusions
	// Required: true
	ScanExclusions []string `json:"scan_exclusions"`

	// scan inclusions
	// Required: true
	ScanInclusions []string `json:"scan_inclusions"`

	// sensor ml level detection
	// Required: true
	SensorMlLevelDetection *int32 `json:"sensor_ml_level_detection"`

	// sensor ml level prevention
	// Required: true
	SensorMlLevelPrevention *int32 `json:"sensor_ml_level_prevention"`
}

// Validate validates this entities o d s scan request
func (m *EntitiesODSScanRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudMlLevelDetection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudMlLevelPrevention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCPUPriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndpointNotification(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiatedFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxFileSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePauseDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuarantine(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanExclusions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanInclusions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSensorMlLevelDetection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSensorMlLevelPrevention(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EntitiesODSScanRequest) validateCloudMlLevelDetection(formats strfmt.Registry) error {

	if err := validate.Required("cloud_ml_level_detection", "body", m.CloudMlLevelDetection); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateCloudMlLevelPrevention(formats strfmt.Registry) error {

	if err := validate.Required("cloud_ml_level_prevention", "body", m.CloudMlLevelPrevention); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateCPUPriority(formats strfmt.Registry) error {

	if err := validate.Required("cpu_priority", "body", m.CPUPriority); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateDescription(formats strfmt.Registry) error {

	if err := validate.Required("description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateEndpointNotification(formats strfmt.Registry) error {

	if err := validate.Required("endpoint_notification", "body", m.EndpointNotification); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateFilePaths(formats strfmt.Registry) error {

	if err := validate.Required("file_paths", "body", m.FilePaths); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateHostGroups(formats strfmt.Registry) error {

	if err := validate.Required("host_groups", "body", m.HostGroups); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateHosts(formats strfmt.Registry) error {

	if err := validate.Required("hosts", "body", m.Hosts); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateInitiatedFrom(formats strfmt.Registry) error {

	if err := validate.Required("initiated_from", "body", m.InitiatedFrom); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateMaxDuration(formats strfmt.Registry) error {

	if err := validate.Required("max_duration", "body", m.MaxDuration); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateMaxFileSize(formats strfmt.Registry) error {

	if err := validate.Required("max_file_size", "body", m.MaxFileSize); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validatePauseDuration(formats strfmt.Registry) error {

	if err := validate.Required("pause_duration", "body", m.PauseDuration); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateQuarantine(formats strfmt.Registry) error {

	if err := validate.Required("quarantine", "body", m.Quarantine); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateScanExclusions(formats strfmt.Registry) error {

	if err := validate.Required("scan_exclusions", "body", m.ScanExclusions); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateScanInclusions(formats strfmt.Registry) error {

	if err := validate.Required("scan_inclusions", "body", m.ScanInclusions); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateSensorMlLevelDetection(formats strfmt.Registry) error {

	if err := validate.Required("sensor_ml_level_detection", "body", m.SensorMlLevelDetection); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScanRequest) validateSensorMlLevelPrevention(formats strfmt.Registry) error {

	if err := validate.Required("sensor_ml_level_prevention", "body", m.SensorMlLevelPrevention); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this entities o d s scan request based on context it is used
func (m *EntitiesODSScanRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *EntitiesODSScanRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EntitiesODSScanRequest) UnmarshalBinary(b []byte) error {
	var res EntitiesODSScanRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
