// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EntitiesODSScheduleScanRequest entities o d s schedule scan request
//
// swagger:model entities.ODSScheduleScanRequest
type EntitiesODSScheduleScanRequest struct {

	// cloud ml level detection
	// Required: true
	CloudMlLevelDetection *int32 `json:"cloud_ml_level_detection"`

	// cloud ml level prevention
	// Required: true
	CloudMlLevelPrevention *int32 `json:"cloud_ml_level_prevention"`

	// cpu priority
	// Required: true
	CPUPriority *int32 `json:"cpu_priority"`

	// description
	// Required: true
	Description *string `json:"description"`

	// endpoint notification
	// Required: true
	EndpointNotification *bool `json:"endpoint_notification"`

	// file paths
	// Required: true
	FilePaths []string `json:"file_paths"`

	// host groups
	// Required: true
	HostGroups []string `json:"host_groups"`

	// initiated from
	// Required: true
	InitiatedFrom *string `json:"initiated_from"`

	// max duration
	// Required: true
	MaxDuration *int32 `json:"max_duration"`

	// max file size
	// Required: true
	MaxFileSize *int32 `json:"max_file_size"`

	// pause duration
	// Required: true
	PauseDuration *int32 `json:"pause_duration"`

	// quarantine
	// Required: true
	Quarantine *bool `json:"quarantine"`

	// scan exclusions
	// Required: true
	ScanExclusions []string `json:"scan_exclusions"`

	// scan inclusions
	// Required: true
	ScanInclusions []string `json:"scan_inclusions"`

	// schedule
	// Required: true
	Schedule *DomainSchedule `json:"schedule"`

	// sensor ml level detection
	// Required: true
	SensorMlLevelDetection *int32 `json:"sensor_ml_level_detection"`

	// sensor ml level prevention
	// Required: true
	SensorMlLevelPrevention *int32 `json:"sensor_ml_level_prevention"`
}

// Validate validates this entities o d s schedule scan request
func (m *EntitiesODSScheduleScanRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudMlLevelDetection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudMlLevelPrevention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCPUPriority(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEndpointNotification(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHostGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiatedFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxFileSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePauseDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQuarantine(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanExclusions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScanInclusions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSensorMlLevelDetection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSensorMlLevelPrevention(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateCloudMlLevelDetection(formats strfmt.Registry) error {

	if err := validate.Required("cloud_ml_level_detection", "body", m.CloudMlLevelDetection); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateCloudMlLevelPrevention(formats strfmt.Registry) error {

	if err := validate.Required("cloud_ml_level_prevention", "body", m.CloudMlLevelPrevention); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateCPUPriority(formats strfmt.Registry) error {

	if err := validate.Required("cpu_priority", "body", m.CPUPriority); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateDescription(formats strfmt.Registry) error {

	if err := validate.Required("description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateEndpointNotification(formats strfmt.Registry) error {

	if err := validate.Required("endpoint_notification", "body", m.EndpointNotification); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateFilePaths(formats strfmt.Registry) error {

	if err := validate.Required("file_paths", "body", m.FilePaths); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateHostGroups(formats strfmt.Registry) error {

	if err := validate.Required("host_groups", "body", m.HostGroups); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateInitiatedFrom(formats strfmt.Registry) error {

	if err := validate.Required("initiated_from", "body", m.InitiatedFrom); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateMaxDuration(formats strfmt.Registry) error {

	if err := validate.Required("max_duration", "body", m.MaxDuration); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateMaxFileSize(formats strfmt.Registry) error {

	if err := validate.Required("max_file_size", "body", m.MaxFileSize); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validatePauseDuration(formats strfmt.Registry) error {

	if err := validate.Required("pause_duration", "body", m.PauseDuration); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateQuarantine(formats strfmt.Registry) error {

	if err := validate.Required("quarantine", "body", m.Quarantine); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateScanExclusions(formats strfmt.Registry) error {

	if err := validate.Required("scan_exclusions", "body", m.ScanExclusions); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateScanInclusions(formats strfmt.Registry) error {

	if err := validate.Required("scan_inclusions", "body", m.ScanInclusions); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateSchedule(formats strfmt.Registry) error {

	if err := validate.Required("schedule", "body", m.Schedule); err != nil {
		return err
	}

	if m.Schedule != nil {
		if err := m.Schedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("schedule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("schedule")
			}
			return err
		}
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateSensorMlLevelDetection(formats strfmt.Registry) error {

	if err := validate.Required("sensor_ml_level_detection", "body", m.SensorMlLevelDetection); err != nil {
		return err
	}

	return nil
}

func (m *EntitiesODSScheduleScanRequest) validateSensorMlLevelPrevention(formats strfmt.Registry) error {

	if err := validate.Required("sensor_ml_level_prevention", "body", m.SensorMlLevelPrevention); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this entities o d s schedule scan request based on the context it is used
func (m *EntitiesODSScheduleScanRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EntitiesODSScheduleScanRequest) contextValidateSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.Schedule != nil {

		if err := m.Schedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("schedule")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("schedule")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EntitiesODSScheduleScanRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EntitiesODSScheduleScanRequest) UnmarshalBinary(b []byte) error {
	var res EntitiesODSScheduleScanRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
