// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FalconxCertificate falconx certificate
//
// swagger:model falconx.Certificate
type FalconxCertificate struct {

	// issuer
	Issuer string `json:"issuer,omitempty"`

	// md5
	Md5 string `json:"md5,omitempty"`

	// owner
	Owner string `json:"owner,omitempty"`

	// serial number
	SerialNumber string `json:"serial_number,omitempty"`

	// sha1
	Sha1 string `json:"sha1,omitempty"`

	// valid from
	// Format: date-time
	ValidFrom strfmt.DateTime `json:"valid_from,omitempty"`

	// valid until
	// Format: date-time
	ValidUntil strfmt.DateTime `json:"valid_until,omitempty"`
}

// Validate validates this falconx certificate
func (m *FalconxCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateValidFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValidUntil(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxCertificate) validateValidFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ValidFrom) { // not required
		return nil
	}

	if err := validate.FormatOf("valid_from", "body", "date-time", m.ValidFrom.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *FalconxCertificate) validateValidUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.ValidUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("valid_until", "body", "date-time", m.ValidUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this falconx certificate based on context it is used
func (m *FalconxCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FalconxCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FalconxCertificate) UnmarshalBinary(b []byte) error {
	var res FalconxCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
