// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// FalconxIntelReportV1 falconx intel report v1
//
// swagger:model falconx.IntelReportV1
type FalconxIntelReportV1 struct {

	// actors
	Actors []*FalconxActor `json:"actors"`

	// malware families
	MalwareFamilies []string `json:"malware_families"`

	// related indicators
	RelatedIndicators []*FalconxRelatedIndicator `json:"related_indicators"`
}

// Validate validates this falconx intel report v1
func (m *FalconxIntelReportV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelatedIndicators(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxIntelReportV1) validateActors(formats strfmt.Registry) error {
	if swag.IsZero(m.Actors) { // not required
		return nil
	}

	for i := 0; i < len(m.Actors); i++ {
		if swag.IsZero(m.Actors[i]) { // not required
			continue
		}

		if m.Actors[i] != nil {
			if err := m.Actors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("actors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FalconxIntelReportV1) validateRelatedIndicators(formats strfmt.Registry) error {
	if swag.IsZero(m.RelatedIndicators) { // not required
		return nil
	}

	for i := 0; i < len(m.RelatedIndicators); i++ {
		if swag.IsZero(m.RelatedIndicators[i]) { // not required
			continue
		}

		if m.RelatedIndicators[i] != nil {
			if err := m.RelatedIndicators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_indicators" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_indicators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this falconx intel report v1 based on the context it is used
func (m *FalconxIntelReportV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelatedIndicators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxIntelReportV1) contextValidateActors(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Actors); i++ {

		if m.Actors[i] != nil {

			if swag.IsZero(m.Actors[i]) { // not required
				return nil
			}

			if err := m.Actors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("actors" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("actors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FalconxIntelReportV1) contextValidateRelatedIndicators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RelatedIndicators); i++ {

		if m.RelatedIndicators[i] != nil {

			if swag.IsZero(m.RelatedIndicators[i]) { // not required
				return nil
			}

			if err := m.RelatedIndicators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("related_indicators" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("related_indicators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *FalconxIntelReportV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FalconxIntelReportV1) UnmarshalBinary(b []byte) error {
	var res FalconxIntelReportV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
