// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// FalconxMalwareConfig falconx malware config
//
// swagger:model falconx.MalwareConfig
type FalconxMalwareConfig struct {

	// bitcoin addresses
	BitcoinAddresses []string `json:"bitcoin_addresses"`

	// c2s
	C2s []*FalconxC2 `json:"c2s"`

	// campaign id
	CampaignID []string `json:"campaign_id"`

	// encryption keys
	EncryptionKeys []string `json:"encryption_keys"`

	// family
	Family []string `json:"family"`

	// mitre attacks
	MitreAttacks []*FalconxMITREAttack `json:"mitre_attacks"`

	// mutexes
	Mutexes []string `json:"mutexes"`

	// passwords
	Passwords []string `json:"passwords"`

	// plugin version
	PluginVersion string `json:"plugin_version,omitempty"`

	// rs4 key
	Rs4Key string `json:"rs4_key,omitempty"`

	// rsa
	Rsa string `json:"rsa,omitempty"`

	// urls
	Urls []string `json:"urls"`

	// version
	Version string `json:"version,omitempty"`
}

// Validate validates this falconx malware config
func (m *FalconxMalwareConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateC2s(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMitreAttacks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxMalwareConfig) validateC2s(formats strfmt.Registry) error {
	if swag.IsZero(m.C2s) { // not required
		return nil
	}

	for i := 0; i < len(m.C2s); i++ {
		if swag.IsZero(m.C2s[i]) { // not required
			continue
		}

		if m.C2s[i] != nil {
			if err := m.C2s[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("c2s" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("c2s" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FalconxMalwareConfig) validateMitreAttacks(formats strfmt.Registry) error {
	if swag.IsZero(m.MitreAttacks) { // not required
		return nil
	}

	for i := 0; i < len(m.MitreAttacks); i++ {
		if swag.IsZero(m.MitreAttacks[i]) { // not required
			continue
		}

		if m.MitreAttacks[i] != nil {
			if err := m.MitreAttacks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mitre_attacks" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("mitre_attacks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this falconx malware config based on the context it is used
func (m *FalconxMalwareConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateC2s(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMitreAttacks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxMalwareConfig) contextValidateC2s(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.C2s); i++ {

		if m.C2s[i] != nil {

			if swag.IsZero(m.C2s[i]) { // not required
				return nil
			}

			if err := m.C2s[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("c2s" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("c2s" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *FalconxMalwareConfig) contextValidateMitreAttacks(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MitreAttacks); i++ {

		if m.MitreAttacks[i] != nil {

			if swag.IsZero(m.MitreAttacks[i]) { // not required
				return nil
			}

			if err := m.MitreAttacks[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("mitre_attacks" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("mitre_attacks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *FalconxMalwareConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FalconxMalwareConfig) UnmarshalBinary(b []byte) error {
	var res FalconxMalwareConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
