// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// FalconxSubmissionParametersV1 falconx submission parameters v1
//
// swagger:model falconx.SubmissionParametersV1
type FalconxSubmissionParametersV1 struct {

	// sandbox
	Sandbox []*FalconxSandboxParametersV1 `json:"sandbox"`

	// send email notification
	SendEmailNotification bool `json:"send_email_notification,omitempty"`

	// user tags
	UserTags []string `json:"user_tags"`
}

// Validate validates this falconx submission parameters v1
func (m *FalconxSubmissionParametersV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSandbox(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxSubmissionParametersV1) validateSandbox(formats strfmt.Registry) error {
	if swag.IsZero(m.Sandbox) { // not required
		return nil
	}

	for i := 0; i < len(m.Sandbox); i++ {
		if swag.IsZero(m.Sandbox[i]) { // not required
			continue
		}

		if m.Sandbox[i] != nil {
			if err := m.Sandbox[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sandbox" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("sandbox" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this falconx submission parameters v1 based on the context it is used
func (m *FalconxSubmissionParametersV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSandbox(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FalconxSubmissionParametersV1) contextValidateSandbox(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Sandbox); i++ {

		if m.Sandbox[i] != nil {

			if swag.IsZero(m.Sandbox[i]) { // not required
				return nil
			}

			if err := m.Sandbox[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sandbox" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("sandbox" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *FalconxSubmissionParametersV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FalconxSubmissionParametersV1) UnmarshalBinary(b []byte) error {
	var res FalconxSubmissionParametersV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
