// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FirewallCreateFirewallPolicyReqV1 firewall create firewall policy req v1
//
// swagger:model firewall.CreateFirewallPolicyReqV1
type FirewallCreateFirewallPolicyReqV1 struct {

	// If specified the firewall rules of the firewall policy identified by the id will be used
	CloneID string `json:"clone_id,omitempty"`

	// The description to use when creating the policy
	Description string `json:"description,omitempty"`

	// The name to use when creating the policy
	// Required: true
	Name *string `json:"name"`

	// The name of the platform
	// Required: true
	// Enum: [Windows Mac Linux]
	PlatformName *string `json:"platform_name"`
}

// Validate validates this firewall create firewall policy req v1
func (m *FirewallCreateFirewallPolicyReqV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatformName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FirewallCreateFirewallPolicyReqV1) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

var firewallCreateFirewallPolicyReqV1TypePlatformNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Windows","Mac","Linux"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		firewallCreateFirewallPolicyReqV1TypePlatformNamePropEnum = append(firewallCreateFirewallPolicyReqV1TypePlatformNamePropEnum, v)
	}
}

const (

	// FirewallCreateFirewallPolicyReqV1PlatformNameWindows captures enum value "Windows"
	FirewallCreateFirewallPolicyReqV1PlatformNameWindows string = "Windows"

	// FirewallCreateFirewallPolicyReqV1PlatformNameMac captures enum value "Mac"
	FirewallCreateFirewallPolicyReqV1PlatformNameMac string = "Mac"

	// FirewallCreateFirewallPolicyReqV1PlatformNameLinux captures enum value "Linux"
	FirewallCreateFirewallPolicyReqV1PlatformNameLinux string = "Linux"
)

// prop value enum
func (m *FirewallCreateFirewallPolicyReqV1) validatePlatformNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, firewallCreateFirewallPolicyReqV1TypePlatformNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *FirewallCreateFirewallPolicyReqV1) validatePlatformName(formats strfmt.Registry) error {

	if err := validate.Required("platform_name", "body", m.PlatformName); err != nil {
		return err
	}

	// value enum
	if err := m.validatePlatformNameEnum("platform_name", "body", *m.PlatformName); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this firewall create firewall policy req v1 based on context it is used
func (m *FirewallCreateFirewallPolicyReqV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FirewallCreateFirewallPolicyReqV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FirewallCreateFirewallPolicyReqV1) UnmarshalBinary(b []byte) error {
	var res FirewallCreateFirewallPolicyReqV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
