// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FwmgrAPINetworkLocationsMetadataV1 fwmgr api network locations metadata v1
//
// swagger:model fwmgr.api.NetworkLocationsMetadataV1
type FwmgrAPINetworkLocationsMetadataV1 struct {

	// dns resolution targets polling interval
	// Required: true
	DNSResolutionTargetsPollingInterval *int32 `json:"dns_resolution_targets_polling_interval"`

	// https reachable hosts polling interval
	// Required: true
	HTTPSReachableHostsPollingInterval *int32 `json:"https_reachable_hosts_polling_interval"`

	// icmp request targets polling interval
	// Required: true
	IcmpRequestTargetsPollingInterval *int32 `json:"icmp_request_targets_polling_interval"`
}

// Validate validates this fwmgr api network locations metadata v1
func (m *FwmgrAPINetworkLocationsMetadataV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDNSResolutionTargetsPollingInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPSReachableHostsPollingInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIcmpRequestTargetsPollingInterval(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FwmgrAPINetworkLocationsMetadataV1) validateDNSResolutionTargetsPollingInterval(formats strfmt.Registry) error {

	if err := validate.Required("dns_resolution_targets_polling_interval", "body", m.DNSResolutionTargetsPollingInterval); err != nil {
		return err
	}

	return nil
}

func (m *FwmgrAPINetworkLocationsMetadataV1) validateHTTPSReachableHostsPollingInterval(formats strfmt.Registry) error {

	if err := validate.Required("https_reachable_hosts_polling_interval", "body", m.HTTPSReachableHostsPollingInterval); err != nil {
		return err
	}

	return nil
}

func (m *FwmgrAPINetworkLocationsMetadataV1) validateIcmpRequestTargetsPollingInterval(formats strfmt.Registry) error {

	if err := validate.Required("icmp_request_targets_polling_interval", "body", m.IcmpRequestTargetsPollingInterval); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this fwmgr api network locations metadata v1 based on context it is used
func (m *FwmgrAPINetworkLocationsMetadataV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FwmgrAPINetworkLocationsMetadataV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FwmgrAPINetworkLocationsMetadataV1) UnmarshalBinary(b []byte) error {
	var res FwmgrAPINetworkLocationsMetadataV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
