// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostGroupsCreateGroupReqV1 A specific device group to create
//
// swagger:model host_groups.CreateGroupReqV1
type HostGroupsCreateGroupReqV1 struct {

	// The FQL assignment rule for the group. This may only be specified if the groups type is 'dynamic'
	AssignmentRule string `json:"assignment_rule,omitempty"`

	// The description of the group
	Description string `json:"description,omitempty"`

	// The type of device group to create
	// Required: true
	// Enum: [static dynamic staticByID]
	GroupType *string `json:"group_type"`

	// The name of the group
	// Required: true
	Name *string `json:"name"`
}

// Validate validates this host groups create group req v1
func (m *HostGroupsCreateGroupReqV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var hostGroupsCreateGroupReqV1TypeGroupTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["static","dynamic","staticByID"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hostGroupsCreateGroupReqV1TypeGroupTypePropEnum = append(hostGroupsCreateGroupReqV1TypeGroupTypePropEnum, v)
	}
}

const (

	// HostGroupsCreateGroupReqV1GroupTypeStatic captures enum value "static"
	HostGroupsCreateGroupReqV1GroupTypeStatic string = "static"

	// HostGroupsCreateGroupReqV1GroupTypeDynamic captures enum value "dynamic"
	HostGroupsCreateGroupReqV1GroupTypeDynamic string = "dynamic"

	// HostGroupsCreateGroupReqV1GroupTypeStaticByID captures enum value "staticByID"
	HostGroupsCreateGroupReqV1GroupTypeStaticByID string = "staticByID"
)

// prop value enum
func (m *HostGroupsCreateGroupReqV1) validateGroupTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hostGroupsCreateGroupReqV1TypeGroupTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HostGroupsCreateGroupReqV1) validateGroupType(formats strfmt.Registry) error {

	if err := validate.Required("group_type", "body", m.GroupType); err != nil {
		return err
	}

	// value enum
	if err := m.validateGroupTypeEnum("group_type", "body", *m.GroupType); err != nil {
		return err
	}

	return nil
}

func (m *HostGroupsCreateGroupReqV1) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this host groups create group req v1 based on context it is used
func (m *HostGroupsCreateGroupReqV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HostGroupsCreateGroupReqV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostGroupsCreateGroupReqV1) UnmarshalBinary(b []byte) error {
	var res HostGroupsCreateGroupReqV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
