// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// K8sregAzureSubscriptionResp k8sreg azure subscription resp
//
// swagger:model k8sreg.AzureSubscriptionResp
type K8sregAzureSubscriptionResp struct {

	// azure permissions status
	// Required: true
	AzurePermissionsStatus []*K8sregAccountPermissionsStatus `json:"azure_permissions_status"`

	// created at
	// Required: true
	// Format: date-time
	CreatedAt *strfmt.DateTime `json:"created_at"`

	// from cspm
	// Required: true
	FromCspm *bool `json:"from_cspm"`

	// status
	// Required: true
	Status *string `json:"status"`

	// subscription id
	// Required: true
	SubscriptionID *string `json:"subscription_id"`

	// tenant id
	// Required: true
	TenantID *string `json:"tenant_id"`

	// updated at
	// Required: true
	// Format: date-time
	UpdatedAt *strfmt.DateTime `json:"updated_at"`
}

// Validate validates this k8sreg azure subscription resp
func (m *K8sregAzureSubscriptionResp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAzurePermissionsStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFromCspm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubscriptionID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTenantID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *K8sregAzureSubscriptionResp) validateAzurePermissionsStatus(formats strfmt.Registry) error {

	if err := validate.Required("azure_permissions_status", "body", m.AzurePermissionsStatus); err != nil {
		return err
	}

	for i := 0; i < len(m.AzurePermissionsStatus); i++ {
		if swag.IsZero(m.AzurePermissionsStatus[i]) { // not required
			continue
		}

		if m.AzurePermissionsStatus[i] != nil {
			if err := m.AzurePermissionsStatus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *K8sregAzureSubscriptionResp) validateCreatedAt(formats strfmt.Registry) error {

	if err := validate.Required("created_at", "body", m.CreatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *K8sregAzureSubscriptionResp) validateFromCspm(formats strfmt.Registry) error {

	if err := validate.Required("from_cspm", "body", m.FromCspm); err != nil {
		return err
	}

	return nil
}

func (m *K8sregAzureSubscriptionResp) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *K8sregAzureSubscriptionResp) validateSubscriptionID(formats strfmt.Registry) error {

	if err := validate.Required("subscription_id", "body", m.SubscriptionID); err != nil {
		return err
	}

	return nil
}

func (m *K8sregAzureSubscriptionResp) validateTenantID(formats strfmt.Registry) error {

	if err := validate.Required("tenant_id", "body", m.TenantID); err != nil {
		return err
	}

	return nil
}

func (m *K8sregAzureSubscriptionResp) validateUpdatedAt(formats strfmt.Registry) error {

	if err := validate.Required("updated_at", "body", m.UpdatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this k8sreg azure subscription resp based on the context it is used
func (m *K8sregAzureSubscriptionResp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAzurePermissionsStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *K8sregAzureSubscriptionResp) contextValidateAzurePermissionsStatus(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AzurePermissionsStatus); i++ {

		if m.AzurePermissionsStatus[i] != nil {

			if swag.IsZero(m.AzurePermissionsStatus[i]) { // not required
				return nil
			}

			if err := m.AzurePermissionsStatus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *K8sregAzureSubscriptionResp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *K8sregAzureSubscriptionResp) UnmarshalBinary(b []byte) error {
	var res K8sregAzureSubscriptionResp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
