// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// K8sregClusterResp k8sreg cluster resp
//
// swagger:model k8sreg.ClusterResp
type K8sregClusterResp struct {

	// account id
	// Required: true
	AccountID *string `json:"account_id"`

	// agent version
	// Required: true
	AgentVersion *K8sregVersionResp `json:"agent_version"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// cluster id
	// Required: true
	ClusterID *string `json:"cluster_id"`

	// cluster name
	// Required: true
	ClusterName *string `json:"cluster_name"`

	// cluster service
	// Required: true
	ClusterService *string `json:"cluster_service"`

	// created at
	// Required: true
	// Format: date-time
	CreatedAt *strfmt.DateTime `json:"created_at"`

	// helm version
	// Required: true
	HelmVersion *K8sregVersionResp `json:"helm_version"`

	// k8s version
	// Required: true
	K8sVersion *K8sregVersionResp `json:"k8s_version"`

	// last heartbeat at
	// Required: true
	// Format: date-time
	LastHeartbeatAt *strfmt.DateTime `json:"last_heartbeat_at"`

	// location
	// Required: true
	Location *string `json:"location"`

	// status
	// Required: true
	Status *string `json:"status"`

	// updated at
	// Required: true
	// Format: date-time
	UpdatedAt *strfmt.DateTime `json:"updated_at"`
}

// Validate validates this k8sreg cluster resp
func (m *K8sregClusterResp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccountID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHelmVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateK8sVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastHeartbeatAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *K8sregClusterResp) validateAccountID(formats strfmt.Registry) error {

	if err := validate.Required("account_id", "body", m.AccountID); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateAgentVersion(formats strfmt.Registry) error {

	if err := validate.Required("agent_version", "body", m.AgentVersion); err != nil {
		return err
	}

	if m.AgentVersion != nil {
		if err := m.AgentVersion.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("agent_version")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("agent_version")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregClusterResp) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateClusterID(formats strfmt.Registry) error {

	if err := validate.Required("cluster_id", "body", m.ClusterID); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateClusterName(formats strfmt.Registry) error {

	if err := validate.Required("cluster_name", "body", m.ClusterName); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateClusterService(formats strfmt.Registry) error {

	if err := validate.Required("cluster_service", "body", m.ClusterService); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateCreatedAt(formats strfmt.Registry) error {

	if err := validate.Required("created_at", "body", m.CreatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateHelmVersion(formats strfmt.Registry) error {

	if err := validate.Required("helm_version", "body", m.HelmVersion); err != nil {
		return err
	}

	if m.HelmVersion != nil {
		if err := m.HelmVersion.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("helm_version")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("helm_version")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregClusterResp) validateK8sVersion(formats strfmt.Registry) error {

	if err := validate.Required("k8s_version", "body", m.K8sVersion); err != nil {
		return err
	}

	if m.K8sVersion != nil {
		if err := m.K8sVersion.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("k8s_version")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("k8s_version")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregClusterResp) validateLastHeartbeatAt(formats strfmt.Registry) error {

	if err := validate.Required("last_heartbeat_at", "body", m.LastHeartbeatAt); err != nil {
		return err
	}

	if err := validate.FormatOf("last_heartbeat_at", "body", "date-time", m.LastHeartbeatAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateLocation(formats strfmt.Registry) error {

	if err := validate.Required("location", "body", m.Location); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *K8sregClusterResp) validateUpdatedAt(formats strfmt.Registry) error {

	if err := validate.Required("updated_at", "body", m.UpdatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this k8sreg cluster resp based on the context it is used
func (m *K8sregClusterResp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAgentVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHelmVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateK8sVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *K8sregClusterResp) contextValidateAgentVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.AgentVersion != nil {

		if err := m.AgentVersion.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("agent_version")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("agent_version")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregClusterResp) contextValidateHelmVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.HelmVersion != nil {

		if err := m.HelmVersion.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("helm_version")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("helm_version")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregClusterResp) contextValidateK8sVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.K8sVersion != nil {

		if err := m.K8sVersion.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("k8s_version")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("k8s_version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *K8sregClusterResp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *K8sregClusterResp) UnmarshalBinary(b []byte) error {
	var res K8sregClusterResp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
