// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// K8sregListClusterCloudItemResp k8sreg list cluster cloud item resp
//
// swagger:model k8sreg.ListClusterCloudItemResp
type K8sregListClusterCloudItemResp struct {

	// account id
	// Required: true
	AccountID *string `json:"account_id"`

	// aws meta
	AwsMeta *K8sregAWSClusterItemResp `json:"aws_meta,omitempty"`

	// azure meta
	AzureMeta *K8sregAzureAcctClusterItemResp `json:"azure_meta,omitempty"`

	// cloud status
	// Required: true
	CloudStatus *string `json:"cloud_status"`

	// cluster name
	ClusterName string `json:"cluster_name,omitempty"`

	// cluster service
	// Required: true
	ClusterService *string `json:"cluster_service"`

	// cluster status
	ClusterStatus string `json:"cluster_status,omitempty"`

	// from cspm
	FromCspm bool `json:"from_cspm,omitempty"`

	// location
	Location string `json:"location,omitempty"`
}

// Validate validates this k8sreg list cluster cloud item resp
func (m *K8sregListClusterCloudItemResp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccountID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAwsMeta(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzureMeta(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *K8sregListClusterCloudItemResp) validateAccountID(formats strfmt.Registry) error {

	if err := validate.Required("account_id", "body", m.AccountID); err != nil {
		return err
	}

	return nil
}

func (m *K8sregListClusterCloudItemResp) validateAwsMeta(formats strfmt.Registry) error {
	if swag.IsZero(m.AwsMeta) { // not required
		return nil
	}

	if m.AwsMeta != nil {
		if err := m.AwsMeta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aws_meta")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aws_meta")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregListClusterCloudItemResp) validateAzureMeta(formats strfmt.Registry) error {
	if swag.IsZero(m.AzureMeta) { // not required
		return nil
	}

	if m.AzureMeta != nil {
		if err := m.AzureMeta.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure_meta")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure_meta")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregListClusterCloudItemResp) validateCloudStatus(formats strfmt.Registry) error {

	if err := validate.Required("cloud_status", "body", m.CloudStatus); err != nil {
		return err
	}

	return nil
}

func (m *K8sregListClusterCloudItemResp) validateClusterService(formats strfmt.Registry) error {

	if err := validate.Required("cluster_service", "body", m.ClusterService); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this k8sreg list cluster cloud item resp based on the context it is used
func (m *K8sregListClusterCloudItemResp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAwsMeta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAzureMeta(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *K8sregListClusterCloudItemResp) contextValidateAwsMeta(ctx context.Context, formats strfmt.Registry) error {

	if m.AwsMeta != nil {

		if swag.IsZero(m.AwsMeta) { // not required
			return nil
		}

		if err := m.AwsMeta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aws_meta")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aws_meta")
			}
			return err
		}
	}

	return nil
}

func (m *K8sregListClusterCloudItemResp) contextValidateAzureMeta(ctx context.Context, formats strfmt.Registry) error {

	if m.AzureMeta != nil {

		if swag.IsZero(m.AzureMeta) { // not required
			return nil
		}

		if err := m.AzureMeta.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("azure_meta")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("azure_meta")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *K8sregListClusterCloudItemResp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *K8sregListClusterCloudItemResp) UnmarshalBinary(b []byte) error {
	var res K8sregListClusterCloudItemResp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
