// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MainAvailableStreamV2 main available stream v2
//
// swagger:model main.availableStreamV2
type MainAvailableStreamV2 struct {

	// data feed URL
	// Required: true
	DataFeedURL *string `json:"dataFeedURL"`

	// refresh active session interval
	// Required: true
	RefreshActiveSessionInterval *int64 `json:"refreshActiveSessionInterval"`

	// refresh active session URL
	// Required: true
	RefreshActiveSessionURL *string `json:"refreshActiveSessionURL"`

	// session token
	// Required: true
	SessionToken *MainSessionToken `json:"sessionToken"`
}

// Validate validates this main available stream v2
func (m *MainAvailableStreamV2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataFeedURL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRefreshActiveSessionInterval(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRefreshActiveSessionURL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSessionToken(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MainAvailableStreamV2) validateDataFeedURL(formats strfmt.Registry) error {

	if err := validate.Required("dataFeedURL", "body", m.DataFeedURL); err != nil {
		return err
	}

	return nil
}

func (m *MainAvailableStreamV2) validateRefreshActiveSessionInterval(formats strfmt.Registry) error {

	if err := validate.Required("refreshActiveSessionInterval", "body", m.RefreshActiveSessionInterval); err != nil {
		return err
	}

	return nil
}

func (m *MainAvailableStreamV2) validateRefreshActiveSessionURL(formats strfmt.Registry) error {

	if err := validate.Required("refreshActiveSessionURL", "body", m.RefreshActiveSessionURL); err != nil {
		return err
	}

	return nil
}

func (m *MainAvailableStreamV2) validateSessionToken(formats strfmt.Registry) error {

	if err := validate.Required("sessionToken", "body", m.SessionToken); err != nil {
		return err
	}

	if m.SessionToken != nil {
		if err := m.SessionToken.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sessionToken")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sessionToken")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this main available stream v2 based on the context it is used
func (m *MainAvailableStreamV2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSessionToken(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MainAvailableStreamV2) contextValidateSessionToken(ctx context.Context, formats strfmt.Registry) error {

	if m.SessionToken != nil {

		if err := m.SessionToken.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sessionToken")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sessionToken")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MainAvailableStreamV2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MainAvailableStreamV2) UnmarshalBinary(b []byte) error {
	var res MainAvailableStreamV2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
