// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MalqueryExternalHuntParametersV1 malquery external hunt parameters v1
//
// swagger:model malquery.ExternalHuntParametersV1
type MalqueryExternalHuntParametersV1 struct {

	// Optional advanced searching parameters
	Options *MalqueryExternalHuntOptions `json:"options,omitempty"`

	// A YARA rule that defines your search
	// Required: true
	YaraRule *string `json:"yara_rule"`
}

// Validate validates this malquery external hunt parameters v1
func (m *MalqueryExternalHuntParametersV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateYaraRule(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MalqueryExternalHuntParametersV1) validateOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.Options) { // not required
		return nil
	}

	if m.Options != nil {
		if err := m.Options.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("options")
			}
			return err
		}
	}

	return nil
}

func (m *MalqueryExternalHuntParametersV1) validateYaraRule(formats strfmt.Registry) error {

	if err := validate.Required("yara_rule", "body", m.YaraRule); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this malquery external hunt parameters v1 based on the context it is used
func (m *MalqueryExternalHuntParametersV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MalqueryExternalHuntParametersV1) contextValidateOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.Options != nil {

		if swag.IsZero(m.Options) { // not required
			return nil
		}

		if err := m.Options.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("options")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MalqueryExternalHuntParametersV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MalqueryExternalHuntParametersV1) UnmarshalBinary(b []byte) error {
	var res MalqueryExternalHuntParametersV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
