// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MalqueryExternalResource malquery external resource
//
// swagger:model malquery.ExternalResource
type MalqueryExternalResource struct {

	// Sample family
	Family string `json:"family,omitempty"`

	// Sample size
	Filesize int32 `json:"filesize,omitempty"`

	// Sample file type
	Filetype string `json:"filetype,omitempty"`

	// Date when it was first seen
	FirstSeen string `json:"first_seen,omitempty"`

	// Reason why the resource is ignored
	IgnoreReason string `json:"ignore_reason,omitempty"`

	// Sample label
	Label string `json:"label,omitempty"`

	// Resource label confidence
	LabelConfidence string `json:"label_confidence,omitempty"`

	// Sample MD5
	Md5 string `json:"md5,omitempty"`

	// Search pattern
	Pattern string `json:"pattern,omitempty"`

	// Search pattern type
	PatternType string `json:"pattern_type,omitempty"`

	// List of sample metadata
	// Required: true
	Samples []*MalquerySampleMetadata `json:"samples"`

	// Sample SHA1
	Sha1 string `json:"sha1,omitempty"`

	// Sample SHA256
	Sha256 string `json:"sha256,omitempty"`

	// List of resource tags
	Tags []string `json:"tags"`

	// Search YARA rule
	YaraRule string `json:"yara_rule,omitempty"`

	// List of YARA rules for related files
	YaraRules []string `json:"yara_rules"`
}

// Validate validates this malquery external resource
func (m *MalqueryExternalResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSamples(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MalqueryExternalResource) validateSamples(formats strfmt.Registry) error {

	if err := validate.Required("samples", "body", m.Samples); err != nil {
		return err
	}

	for i := 0; i < len(m.Samples); i++ {
		if swag.IsZero(m.Samples[i]) { // not required
			continue
		}

		if m.Samples[i] != nil {
			if err := m.Samples[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("samples" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("samples" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this malquery external resource based on the context it is used
func (m *MalqueryExternalResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSamples(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MalqueryExternalResource) contextValidateSamples(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Samples); i++ {

		if m.Samples[i] != nil {

			if swag.IsZero(m.Samples[i]) { // not required
				return nil
			}

			if err := m.Samples[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("samples" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("samples" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *MalqueryExternalResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MalqueryExternalResource) UnmarshalBinary(b []byte) error {
	var res MalqueryExternalResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
