// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MalqueryRateLimitsMeta malquery rate limits meta
//
// swagger:model malquery.RateLimitsMeta
type MalqueryRateLimitsMeta struct {

	// Days left until the limits are refreshed
	// Required: true
	DaysLeft *int32 `json:"days_left"`

	// How many downloads were executed in the last month
	// Required: true
	DownloadCount *int32 `json:"download_count"`

	// Download counts per user
	DownloadCounts []*MalqueryUserRequestCount `json:"download_counts"`

	// Total download limit per month
	// Required: true
	DownloadLimit *int32 `json:"download_limit"`

	// How many hunts were executed in the last month
	// Required: true
	HuntCount *int32 `json:"hunt_count"`

	// Hunt counts per user
	HuntCounts []*MalqueryUserRequestCount `json:"hunt_counts"`

	// Total hunt limit per month
	// Required: true
	HuntLimit *int32 `json:"hunt_limit"`

	// How many monitors were created in the last month
	// Required: true
	MonitorCount *int32 `json:"monitor_count"`

	// Total monitor limit per month
	// Required: true
	MonitorLimit *int32 `json:"monitor_limit"`

	// Time when the limits are refreshed. ISO 8601 format
	// Required: true
	RefreshTime *string `json:"refresh_time"`
}

// Validate validates this malquery rate limits meta
func (m *MalqueryRateLimitsMeta) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDaysLeft(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDownloadCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDownloadCounts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDownloadLimit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHuntCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHuntCounts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHuntLimit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonitorCount(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMonitorLimit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRefreshTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MalqueryRateLimitsMeta) validateDaysLeft(formats strfmt.Registry) error {

	if err := validate.Required("days_left", "body", m.DaysLeft); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateDownloadCount(formats strfmt.Registry) error {

	if err := validate.Required("download_count", "body", m.DownloadCount); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateDownloadCounts(formats strfmt.Registry) error {
	if swag.IsZero(m.DownloadCounts) { // not required
		return nil
	}

	for i := 0; i < len(m.DownloadCounts); i++ {
		if swag.IsZero(m.DownloadCounts[i]) { // not required
			continue
		}

		if m.DownloadCounts[i] != nil {
			if err := m.DownloadCounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("download_counts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("download_counts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateDownloadLimit(formats strfmt.Registry) error {

	if err := validate.Required("download_limit", "body", m.DownloadLimit); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateHuntCount(formats strfmt.Registry) error {

	if err := validate.Required("hunt_count", "body", m.HuntCount); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateHuntCounts(formats strfmt.Registry) error {
	if swag.IsZero(m.HuntCounts) { // not required
		return nil
	}

	for i := 0; i < len(m.HuntCounts); i++ {
		if swag.IsZero(m.HuntCounts[i]) { // not required
			continue
		}

		if m.HuntCounts[i] != nil {
			if err := m.HuntCounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("hunt_counts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("hunt_counts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateHuntLimit(formats strfmt.Registry) error {

	if err := validate.Required("hunt_limit", "body", m.HuntLimit); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateMonitorCount(formats strfmt.Registry) error {

	if err := validate.Required("monitor_count", "body", m.MonitorCount); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateMonitorLimit(formats strfmt.Registry) error {

	if err := validate.Required("monitor_limit", "body", m.MonitorLimit); err != nil {
		return err
	}

	return nil
}

func (m *MalqueryRateLimitsMeta) validateRefreshTime(formats strfmt.Registry) error {

	if err := validate.Required("refresh_time", "body", m.RefreshTime); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this malquery rate limits meta based on the context it is used
func (m *MalqueryRateLimitsMeta) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDownloadCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHuntCounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MalqueryRateLimitsMeta) contextValidateDownloadCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DownloadCounts); i++ {

		if m.DownloadCounts[i] != nil {

			if swag.IsZero(m.DownloadCounts[i]) { // not required
				return nil
			}

			if err := m.DownloadCounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("download_counts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("download_counts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *MalqueryRateLimitsMeta) contextValidateHuntCounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.HuntCounts); i++ {

		if m.HuntCounts[i] != nil {

			if swag.IsZero(m.HuntCounts[i]) { // not required
				return nil
			}

			if err := m.HuntCounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("hunt_counts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("hunt_counts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *MalqueryRateLimitsMeta) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MalqueryRateLimitsMeta) UnmarshalBinary(b []byte) error {
	var res MalqueryRateLimitsMeta
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
