// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ModelSessionLog model session log
//
// swagger:model model.SessionLog
type ModelSessionLog struct {

	// base command
	// Required: true
	BaseCommand *string `json:"base_command"`

	// cloud request id
	// Required: true
	CloudRequestID *string `json:"cloud_request_id"`

	// command string
	// Required: true
	CommandString *string `json:"command_string"`

	// created at
	// Required: true
	// Format: date-time
	CreatedAt *strfmt.DateTime `json:"created_at"`

	// current directory
	// Required: true
	CurrentDirectory *string `json:"current_directory"`

	// id
	// Required: true
	ID *int64 `json:"id"`

	// session id
	// Required: true
	SessionID *string `json:"session_id"`

	// updated at
	// Required: true
	// Format: date-time
	UpdatedAt *strfmt.DateTime `json:"updated_at"`
}

// Validate validates this model session log
func (m *ModelSessionLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBaseCommand(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudRequestID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCommandString(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCurrentDirectory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSessionID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelSessionLog) validateBaseCommand(formats strfmt.Registry) error {

	if err := validate.Required("base_command", "body", m.BaseCommand); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateCloudRequestID(formats strfmt.Registry) error {

	if err := validate.Required("cloud_request_id", "body", m.CloudRequestID); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateCommandString(formats strfmt.Registry) error {

	if err := validate.Required("command_string", "body", m.CommandString); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateCreatedAt(formats strfmt.Registry) error {

	if err := validate.Required("created_at", "body", m.CreatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateCurrentDirectory(formats strfmt.Registry) error {

	if err := validate.Required("current_directory", "body", m.CurrentDirectory); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateSessionID(formats strfmt.Registry) error {

	if err := validate.Required("session_id", "body", m.SessionID); err != nil {
		return err
	}

	return nil
}

func (m *ModelSessionLog) validateUpdatedAt(formats strfmt.Registry) error {

	if err := validate.Required("updated_at", "body", m.UpdatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this model session log based on context it is used
func (m *ModelSessionLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ModelSessionLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelSessionLog) UnmarshalBinary(b []byte) error {
	var res ModelSessionLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
