// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ModelsAWSAccountV1 models a w s account v1
//
// swagger:model models.AWSAccountV1
type ModelsAWSAccountV1 struct {

	// Provides details regarding current health of access to target account.
	AccessHealth *ModelsAwsAccountAccessHealth `json:"access_health,omitempty"`

	// Alias/Name associated with the account. This is only updated once the account is in a registered state.
	Alias string `json:"alias,omitempty"`

	// cid
	Cid string `json:"cid,omitempty"`

	// Unique identifier for the cloudformation stack id used for provisioning.
	CloudformationStackID string `json:"cloudformation_stack_id,omitempty"`

	// URL of the CloudFormation template to execute. This is returned when mode is to set 'cloudformation' when provisioning.
	CloudformationURL string `json:"cloudformation_url,omitempty"`

	// The 12 digit AWS account which is hosting the S3 bucket containing cloudtrail logs for this account. If this field is set, it takes precedence of the settings level field.
	CloudtrailBucketOwnerID string `json:"cloudtrail_bucket_owner_id,omitempty"`

	// Region where the S3 bucket containing cloudtrail logs resides. This is only set if using cloudformation to provision and create the trail.
	CloudtrailBucketRegion string `json:"cloudtrail_bucket_region,omitempty"`

	// Timestamp of when the account was first provisioned within CrowdStrike's system.'
	CreatedTimestamp string `json:"created_timestamp,omitempty"`

	// ID assigned for use with cross account IAM role access.
	ExternalID string `json:"external_id,omitempty"`

	// The full arn of the IAM role created in this account to control access.
	IamRoleArn string `json:"iam_role_arn,omitempty"`

	// 12 digit AWS provided unique identifier for the account.
	ID string `json:"id,omitempty"`

	// Timestamp of when the account was last modified.
	LastModifiedTimestamp string `json:"last_modified_timestamp,omitempty"`

	// Timestamp of when the account was scanned.
	LastScannedTimestamp string `json:"last_scanned_timestamp,omitempty"`

	// Current version of permissions associated with IAM role and granted access.
	PolicyVersion string `json:"policy_version,omitempty"`

	// Provisioning state of the account. Values can be; initiated, registered, unregistered.
	ProvisioningState string `json:"provisioning_state,omitempty"`

	// Rate limiting setting to control the maximum number of requests that can be made within the rate_limit_time duration.
	RateLimitReqs int64 `json:"rate_limit_reqs,omitempty"`

	// Rate limiting setting to control the number of seconds for which rate_limit_reqs applies.
	RateLimitTime int64 `json:"rate_limit_time,omitempty"`

	// Current version of cloudformation template used to manage access.
	TemplateVersion string `json:"template_version,omitempty"`
}

// Validate validates this models a w s account v1
func (m *ModelsAWSAccountV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessHealth(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelsAWSAccountV1) validateAccessHealth(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessHealth) { // not required
		return nil
	}

	if m.AccessHealth != nil {
		if err := m.AccessHealth.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_health")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("access_health")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this models a w s account v1 based on the context it is used
func (m *ModelsAWSAccountV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccessHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelsAWSAccountV1) contextValidateAccessHealth(ctx context.Context, formats strfmt.Registry) error {

	if m.AccessHealth != nil {

		if swag.IsZero(m.AccessHealth) { // not required
			return nil
		}

		if err := m.AccessHealth.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_health")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("access_health")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ModelsAWSAccountV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelsAWSAccountV1) UnmarshalBinary(b []byte) error {
	var res ModelsAWSAccountV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
