// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ModelsJobMetaData models job meta data
//
// swagger:model models.JobMetaData
type ModelsJobMetaData struct {

	// cloud provider
	// Required: true
	CloudProvider *string `json:"cloud_provider"`

	// instance id
	// Required: true
	InstanceID *string `json:"instance_id"`

	// job end time
	// Required: true
	// Format: date-time
	JobEndTime *strfmt.DateTime `json:"job_end_time"`

	// job id
	// Required: true
	JobID *string `json:"job_id"`

	// job start time
	// Required: true
	// Format: date-time
	JobStartTime *strfmt.DateTime `json:"job_start_time"`

	// message
	// Required: true
	Message *string `json:"message"`

	// scanner version
	// Required: true
	ScannerVersion *string `json:"scanner_version"`

	// status
	// Required: true
	Status *string `json:"status"`
}

// Validate validates this models job meta data
func (m *ModelsJobMetaData) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJobEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJobID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJobStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScannerVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelsJobMetaData) validateCloudProvider(formats strfmt.Registry) error {

	if err := validate.Required("cloud_provider", "body", m.CloudProvider); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("instance_id", "body", m.InstanceID); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateJobEndTime(formats strfmt.Registry) error {

	if err := validate.Required("job_end_time", "body", m.JobEndTime); err != nil {
		return err
	}

	if err := validate.FormatOf("job_end_time", "body", "date-time", m.JobEndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateJobID(formats strfmt.Registry) error {

	if err := validate.Required("job_id", "body", m.JobID); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateJobStartTime(formats strfmt.Registry) error {

	if err := validate.Required("job_start_time", "body", m.JobStartTime); err != nil {
		return err
	}

	if err := validate.FormatOf("job_start_time", "body", "date-time", m.JobStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateMessage(formats strfmt.Registry) error {

	if err := validate.Required("message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateScannerVersion(formats strfmt.Registry) error {

	if err := validate.Required("scanner_version", "body", m.ScannerVersion); err != nil {
		return err
	}

	return nil
}

func (m *ModelsJobMetaData) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this models job meta data based on context it is used
func (m *ModelsJobMetaData) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ModelsJobMetaData) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelsJobMetaData) UnmarshalBinary(b []byte) error {
	var res ModelsJobMetaData
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
