// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ModelsSnapshotInventoryApplication models snapshot inventory application
//
// swagger:model models.SnapshotInventoryApplication
type ModelsSnapshotInventoryApplication struct {

	// major version
	// Required: true
	MajorVersion *string `json:"major_version"`

	// package hash
	// Required: true
	PackageHash *string `json:"package_hash"`

	// package provider
	// Required: true
	PackageProvider *string `json:"package_provider"`

	// package source
	// Required: true
	PackageSource *string `json:"package_source"`

	// path
	// Required: true
	Path *string `json:"path"`

	// product
	// Required: true
	Product *string `json:"product"`

	// software architecture
	// Required: true
	SoftwareArchitecture *string `json:"software_architecture"`

	// type
	// Required: true
	Type *string `json:"type"`

	// vendor
	// Required: true
	Vendor *string `json:"vendor"`
}

// Validate validates this models snapshot inventory application
func (m *ModelsSnapshotInventoryApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMajorVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePackageHash(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePackageProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePackageSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProduct(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSoftwareArchitecture(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVendor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelsSnapshotInventoryApplication) validateMajorVersion(formats strfmt.Registry) error {

	if err := validate.Required("major_version", "body", m.MajorVersion); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validatePackageHash(formats strfmt.Registry) error {

	if err := validate.Required("package_hash", "body", m.PackageHash); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validatePackageProvider(formats strfmt.Registry) error {

	if err := validate.Required("package_provider", "body", m.PackageProvider); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validatePackageSource(formats strfmt.Registry) error {

	if err := validate.Required("package_source", "body", m.PackageSource); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validatePath(formats strfmt.Registry) error {

	if err := validate.Required("path", "body", m.Path); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validateProduct(formats strfmt.Registry) error {

	if err := validate.Required("product", "body", m.Product); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validateSoftwareArchitecture(formats strfmt.Registry) error {

	if err := validate.Required("software_architecture", "body", m.SoftwareArchitecture); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ModelsSnapshotInventoryApplication) validateVendor(formats strfmt.Registry) error {

	if err := validate.Required("vendor", "body", m.Vendor); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this models snapshot inventory application based on context it is used
func (m *ModelsSnapshotInventoryApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ModelsSnapshotInventoryApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelsSnapshotInventoryApplication) UnmarshalBinary(b []byte) error {
	var res ModelsSnapshotInventoryApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
