// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PublicDACLEntity public d ACL entity
//
// swagger:model public.DACLEntity
type PublicDACLEntity struct {

	// acl change type
	ACLChangeType int32 `json:"acl_change_type,omitempty"`

	// acl permission change
	// Required: true
	ACLPermissionChange []*PublicAttribute `json:"acl_permission_change"`

	// acl principal
	// Required: true
	ACLPrincipal *string `json:"acl_principal"`

	// Possible values: 0 - ALLOW, 1 - DENY
	// Required: true
	ACLType *int32 `json:"acl_type"`
}

// Validate validates this public d ACL entity
func (m *PublicDACLEntity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateACLPermissionChange(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateACLPrincipal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateACLType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicDACLEntity) validateACLPermissionChange(formats strfmt.Registry) error {

	if err := validate.Required("acl_permission_change", "body", m.ACLPermissionChange); err != nil {
		return err
	}

	for i := 0; i < len(m.ACLPermissionChange); i++ {
		if swag.IsZero(m.ACLPermissionChange[i]) { // not required
			continue
		}

		if m.ACLPermissionChange[i] != nil {
			if err := m.ACLPermissionChange[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acl_permission_change" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("acl_permission_change" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicDACLEntity) validateACLPrincipal(formats strfmt.Registry) error {

	if err := validate.Required("acl_principal", "body", m.ACLPrincipal); err != nil {
		return err
	}

	return nil
}

func (m *PublicDACLEntity) validateACLType(formats strfmt.Registry) error {

	if err := validate.Required("acl_type", "body", m.ACLType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this public d ACL entity based on the context it is used
func (m *PublicDACLEntity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateACLPermissionChange(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicDACLEntity) contextValidateACLPermissionChange(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ACLPermissionChange); i++ {

		if m.ACLPermissionChange[i] != nil {

			if swag.IsZero(m.ACLPermissionChange[i]) { // not required
				return nil
			}

			if err := m.ACLPermissionChange[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acl_permission_change" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("acl_permission_change" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PublicDACLEntity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublicDACLEntity) UnmarshalBinary(b []byte) error {
	var res PublicDACLEntity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
