// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PublicPermissionsLin public permissions lin
//
// swagger:model public.PermissionsLin
type PublicPermissionsLin struct {

	// acl
	ACL []*PublicACL `json:"acl"`

	// basic
	Basic []*PublicBasic `json:"basic"`

	// default acl
	DefaultACL []*PublicACL `json:"default_acl"`

	// group
	Group *PublicGroup `json:"group,omitempty"`

	// owner
	Owner *PublicOwner `json:"owner,omitempty"`

	// security info
	SecurityInfo int32 `json:"security_info,omitempty"`
}

// Validate validates this public permissions lin
func (m *PublicPermissionsLin) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateACL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBasic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultACL(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicPermissionsLin) validateACL(formats strfmt.Registry) error {
	if swag.IsZero(m.ACL) { // not required
		return nil
	}

	for i := 0; i < len(m.ACL); i++ {
		if swag.IsZero(m.ACL[i]) { // not required
			continue
		}

		if m.ACL[i] != nil {
			if err := m.ACL[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acl" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("acl" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicPermissionsLin) validateBasic(formats strfmt.Registry) error {
	if swag.IsZero(m.Basic) { // not required
		return nil
	}

	for i := 0; i < len(m.Basic); i++ {
		if swag.IsZero(m.Basic[i]) { // not required
			continue
		}

		if m.Basic[i] != nil {
			if err := m.Basic[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("basic" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("basic" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicPermissionsLin) validateDefaultACL(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultACL) { // not required
		return nil
	}

	for i := 0; i < len(m.DefaultACL); i++ {
		if swag.IsZero(m.DefaultACL[i]) { // not required
			continue
		}

		if m.DefaultACL[i] != nil {
			if err := m.DefaultACL[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("default_acl" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("default_acl" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicPermissionsLin) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Group) { // not required
		return nil
	}

	if m.Group != nil {
		if err := m.Group.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *PublicPermissionsLin) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this public permissions lin based on the context it is used
func (m *PublicPermissionsLin) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateACL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBasic(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDefaultACL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PublicPermissionsLin) contextValidateACL(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ACL); i++ {

		if m.ACL[i] != nil {

			if swag.IsZero(m.ACL[i]) { // not required
				return nil
			}

			if err := m.ACL[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acl" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("acl" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicPermissionsLin) contextValidateBasic(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Basic); i++ {

		if m.Basic[i] != nil {

			if swag.IsZero(m.Basic[i]) { // not required
				return nil
			}

			if err := m.Basic[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("basic" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("basic" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicPermissionsLin) contextValidateDefaultACL(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DefaultACL); i++ {

		if m.DefaultACL[i] != nil {

			if swag.IsZero(m.DefaultACL[i]) { // not required
				return nil
			}

			if err := m.DefaultACL[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("default_acl" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("default_acl" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *PublicPermissionsLin) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Group != nil {

		if swag.IsZero(m.Group) { // not required
			return nil
		}

		if err := m.Group.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("group")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("group")
			}
			return err
		}
	}

	return nil
}

func (m *PublicPermissionsLin) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {

		if swag.IsZero(m.Owner) { // not required
			return nil
		}

		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PublicPermissionsLin) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PublicPermissionsLin) UnmarshalBinary(b []byte) error {
	var res PublicPermissionsLin
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
