// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RegistrationAzureAccountV1Ext registration azure account v1 ext
//
// swagger:model registration.AzureAccountV1Ext
type RegistrationAzureAccountV1Ext struct {

	// created at
	// Required: true
	// Format: date-time
	CreatedAt *strfmt.DateTime `json:"CreatedAt"`

	// deleted at
	// Required: true
	// Format: date-time
	DeletedAt *strfmt.DateTime `json:"DeletedAt"`

	// ID
	// Required: true
	ID *int64 `json:"ID"`

	// updated at
	// Required: true
	// Format: date-time
	UpdatedAt *strfmt.DateTime `json:"UpdatedAt"`

	// account type
	AccountType string `json:"account_type,omitempty"`

	// Permissions status returned via API.
	// Required: true
	AzurePermissionsStatus []*DomainPermission `json:"azure_permissions_status"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// client id
	ClientID string `json:"client_id,omitempty"`

	// cloud scopes
	CloudScopes []*DomainCloudScope `json:"cloud_scopes"`

	// conditions
	Conditions []*DomainCondition `json:"conditions"`

	// credentials end date
	// Format: date-time
	CredentialsEndDate strfmt.DateTime `json:"credentials_end_date,omitempty"`

	// credentials type
	CredentialsType string `json:"credentials_type,omitempty"`

	// Default Azure Subscription ID to provision shared IOA infrastructure.
	DefaultSubscriptionID string `json:"default_subscription_id,omitempty"`

	// environment
	Environment string `json:"environment,omitempty"`

	// object id
	ObjectID string `json:"object_id,omitempty"`

	// public certificate
	PublicCertificate string `json:"public_certificate,omitempty"`

	// public certificate raw
	PublicCertificateRaw string `json:"public_certificate_raw,omitempty"`

	// role assignments
	RoleAssignments []*DomainAzureRoleAssignment `json:"role_assignments"`

	// Whether to show modal on the UI instructing existing D4C Azure customer to reregister subscriptions for CSPM.
	// Required: true
	ShowModal *bool `json:"show_modal"`

	// Account registration status.
	Status string `json:"status,omitempty"`

	// Azure Subscription ID.
	SubscriptionID string `json:"subscription_id,omitempty"`

	// Azure Subscription Name.
	SubscriptionName string `json:"subscription_name,omitempty"`

	// Azure Tenant ID to use.
	TenantID string `json:"tenant_id,omitempty"`

	// years valid
	YearsValid int64 `json:"years_valid,omitempty"`
}

// Validate validates this registration azure account v1 ext
func (m *RegistrationAzureAccountV1Ext) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeletedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzurePermissionsStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudScopes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCredentialsEndDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRoleAssignments(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShowModal(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateCreatedAt(formats strfmt.Registry) error {

	if err := validate.Required("CreatedAt", "body", m.CreatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("CreatedAt", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateDeletedAt(formats strfmt.Registry) error {

	if err := validate.Required("DeletedAt", "body", m.DeletedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("DeletedAt", "body", "date-time", m.DeletedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateID(formats strfmt.Registry) error {

	if err := validate.Required("ID", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateUpdatedAt(formats strfmt.Registry) error {

	if err := validate.Required("UpdatedAt", "body", m.UpdatedAt); err != nil {
		return err
	}

	if err := validate.FormatOf("UpdatedAt", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateAzurePermissionsStatus(formats strfmt.Registry) error {

	if err := validate.Required("azure_permissions_status", "body", m.AzurePermissionsStatus); err != nil {
		return err
	}

	for i := 0; i < len(m.AzurePermissionsStatus); i++ {
		if swag.IsZero(m.AzurePermissionsStatus[i]) { // not required
			continue
		}

		if m.AzurePermissionsStatus[i] != nil {
			if err := m.AzurePermissionsStatus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateCloudScopes(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudScopes) { // not required
		return nil
	}

	for i := 0; i < len(m.CloudScopes); i++ {
		if swag.IsZero(m.CloudScopes[i]) { // not required
			continue
		}

		if m.CloudScopes[i] != nil {
			if err := m.CloudScopes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cloud_scopes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("cloud_scopes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.Conditions) { // not required
		return nil
	}

	for i := 0; i < len(m.Conditions); i++ {
		if swag.IsZero(m.Conditions[i]) { // not required
			continue
		}

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateCredentialsEndDate(formats strfmt.Registry) error {
	if swag.IsZero(m.CredentialsEndDate) { // not required
		return nil
	}

	if err := validate.FormatOf("credentials_end_date", "body", "date-time", m.CredentialsEndDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateRoleAssignments(formats strfmt.Registry) error {
	if swag.IsZero(m.RoleAssignments) { // not required
		return nil
	}

	for i := 0; i < len(m.RoleAssignments); i++ {
		if swag.IsZero(m.RoleAssignments[i]) { // not required
			continue
		}

		if m.RoleAssignments[i] != nil {
			if err := m.RoleAssignments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("role_assignments" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("role_assignments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) validateShowModal(formats strfmt.Registry) error {

	if err := validate.Required("show_modal", "body", m.ShowModal); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this registration azure account v1 ext based on the context it is used
func (m *RegistrationAzureAccountV1Ext) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAzurePermissionsStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloudScopes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRoleAssignments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RegistrationAzureAccountV1Ext) contextValidateAzurePermissionsStatus(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AzurePermissionsStatus); i++ {

		if m.AzurePermissionsStatus[i] != nil {

			if swag.IsZero(m.AzurePermissionsStatus[i]) { // not required
				return nil
			}

			if err := m.AzurePermissionsStatus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("azure_permissions_status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) contextValidateCloudScopes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CloudScopes); i++ {

		if m.CloudScopes[i] != nil {

			if swag.IsZero(m.CloudScopes[i]) { // not required
				return nil
			}

			if err := m.CloudScopes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cloud_scopes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("cloud_scopes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) contextValidateConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Conditions); i++ {

		if m.Conditions[i] != nil {

			if swag.IsZero(m.Conditions[i]) { // not required
				return nil
			}

			if err := m.Conditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *RegistrationAzureAccountV1Ext) contextValidateRoleAssignments(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RoleAssignments); i++ {

		if m.RoleAssignments[i] != nil {

			if swag.IsZero(m.RoleAssignments[i]) { // not required
				return nil
			}

			if err := m.RoleAssignments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("role_assignments" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("role_assignments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *RegistrationAzureAccountV1Ext) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RegistrationAzureAccountV1Ext) UnmarshalBinary(b []byte) error {
	var res RegistrationAzureAccountV1Ext
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
