// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RegistrationIOAEvent registration i o a event
//
// swagger:model registration.IOAEvent
type RegistrationIOAEvent struct {

	// additional event data
	AdditionalEventData string `json:"additional_event_data,omitempty"`

	// aggregate
	Aggregate *IoaEventAggregate `json:"aggregate,omitempty"`

	// api version
	APIVersion string `json:"api_version,omitempty"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// cloud account id
	CloudAccountID *IoaCloudAccountID `json:"cloud_account_id,omitempty"`

	// cloud provider
	// Required: true
	CloudProvider *string `json:"cloud_provider"`

	// cloud region
	CloudRegion string `json:"cloud_region,omitempty"`

	// enrichments
	Enrichments *IoaEnrichments `json:"enrichments,omitempty"`

	// error code
	ErrorCode string `json:"error_code,omitempty"`

	// error message
	ErrorMessage string `json:"error_message,omitempty"`

	// event category
	EventCategory string `json:"event_category,omitempty"`

	// event created
	EventCreated string `json:"event_created,omitempty"`

	// event id
	EventID string `json:"event_id,omitempty"`

	// event name
	EventName string `json:"event_name,omitempty"`

	// event source
	EventSource string `json:"event_source,omitempty"`

	// event type
	EventType string `json:"event_type,omitempty"`

	// group id
	GroupID string `json:"group_id,omitempty"`

	// management event
	ManagementEvent bool `json:"management_event,omitempty"`

	// policy id
	// Required: true
	PolicyID *int32 `json:"policy_id"`

	// policy statement
	// Required: true
	PolicyStatement *string `json:"policy_statement"`

	// read only
	ReadOnly bool `json:"read_only,omitempty"`

	// recipient account id
	RecipientAccountID string `json:"recipient_account_id,omitempty"`

	// request id
	RequestID string `json:"request_id,omitempty"`

	// request parameters
	RequestParameters interface{} `json:"request_parameters,omitempty"`

	// resources
	Resources []interface{} `json:"resources"`

	// response elements
	ResponseElements interface{} `json:"response_elements,omitempty"`

	// service
	// Required: true
	Service *string `json:"service"`

	// service event details
	ServiceEventDetails string `json:"service_event_details,omitempty"`

	// severity
	// Required: true
	Severity *string `json:"severity"`

	// shared event id
	SharedEventID string `json:"shared_event_id,omitempty"`

	// source ip address
	SourceIPAddress string `json:"source_ip_address,omitempty"`

	// state
	// Required: true
	State *string `json:"state"`

	// user agent
	UserAgent string `json:"user_agent,omitempty"`

	// user id
	UserID string `json:"user_id,omitempty"`

	// user identity
	UserIdentity interface{} `json:"user_identity,omitempty"`

	// vertex id
	// Required: true
	VertexID *string `json:"vertex_id"`

	// vertex type
	// Required: true
	VertexType *string `json:"vertex_type"`

	// vpc endpoint id
	VpcEndpointID string `json:"vpc_endpoint_id,omitempty"`
}

// Validate validates this registration i o a event
func (m *RegistrationIOAEvent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudAccountID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnrichments(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicyID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicyStatement(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVertexID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVertexType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RegistrationIOAEvent) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *RegistrationIOAEvent) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateCloudAccountID(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudAccountID) { // not required
		return nil
	}

	if m.CloudAccountID != nil {
		if err := m.CloudAccountID.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_account_id")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloud_account_id")
			}
			return err
		}
	}

	return nil
}

func (m *RegistrationIOAEvent) validateCloudProvider(formats strfmt.Registry) error {

	if err := validate.Required("cloud_provider", "body", m.CloudProvider); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateEnrichments(formats strfmt.Registry) error {
	if swag.IsZero(m.Enrichments) { // not required
		return nil
	}

	if m.Enrichments != nil {
		if err := m.Enrichments.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("enrichments")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("enrichments")
			}
			return err
		}
	}

	return nil
}

func (m *RegistrationIOAEvent) validatePolicyID(formats strfmt.Registry) error {

	if err := validate.Required("policy_id", "body", m.PolicyID); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validatePolicyStatement(formats strfmt.Registry) error {

	if err := validate.Required("policy_statement", "body", m.PolicyStatement); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateService(formats strfmt.Registry) error {

	if err := validate.Required("service", "body", m.Service); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateSeverity(formats strfmt.Registry) error {

	if err := validate.Required("severity", "body", m.Severity); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateState(formats strfmt.Registry) error {

	if err := validate.Required("state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateVertexID(formats strfmt.Registry) error {

	if err := validate.Required("vertex_id", "body", m.VertexID); err != nil {
		return err
	}

	return nil
}

func (m *RegistrationIOAEvent) validateVertexType(formats strfmt.Registry) error {

	if err := validate.Required("vertex_type", "body", m.VertexType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this registration i o a event based on the context it is used
func (m *RegistrationIOAEvent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloudAccountID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnrichments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RegistrationIOAEvent) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {

		if swag.IsZero(m.Aggregate) { // not required
			return nil
		}

		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *RegistrationIOAEvent) contextValidateCloudAccountID(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudAccountID != nil {

		if swag.IsZero(m.CloudAccountID) { // not required
			return nil
		}

		if err := m.CloudAccountID.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_account_id")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloud_account_id")
			}
			return err
		}
	}

	return nil
}

func (m *RegistrationIOAEvent) contextValidateEnrichments(ctx context.Context, formats strfmt.Registry) error {

	if m.Enrichments != nil {

		if swag.IsZero(m.Enrichments) { // not required
			return nil
		}

		if err := m.Enrichments.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("enrichments")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("enrichments")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RegistrationIOAEvent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RegistrationIOAEvent) UnmarshalBinary(b []byte) error {
	var res RegistrationIOAEvent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
