// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SadomainNotificationLog sadomain notification log
//
// swagger:model sadomain.NotificationLog
type SadomainNotificationLog struct {

	// action
	// Required: true
	Action *string `json:"action"`

	// cid
	// Required: true
	Cid *string `json:"cid"`

	// created date
	// Required: true
	// Format: date-time
	CreatedDate *strfmt.DateTime `json:"created_date"`

	// details
	// Required: true
	Details *string `json:"details"`

	// id
	// Required: true
	ID *string `json:"id"`

	// message
	// Required: true
	Message *string `json:"message"`

	// notification id
	// Required: true
	NotificationID *string `json:"notification_id"`

	// user email
	// Required: true
	UserEmail *string `json:"user_email"`

	// user uuid
	// Required: true
	UserUUID *string `json:"user_uuid"`

	// username
	// Required: true
	Username *string `json:"username"`
}

// Validate validates this sadomain notification log
func (m *SadomainNotificationLog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNotificationID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserEmail(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SadomainNotificationLog) validateAction(formats strfmt.Registry) error {

	if err := validate.Required("action", "body", m.Action); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateCid(formats strfmt.Registry) error {

	if err := validate.Required("cid", "body", m.Cid); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateCreatedDate(formats strfmt.Registry) error {

	if err := validate.Required("created_date", "body", m.CreatedDate); err != nil {
		return err
	}

	if err := validate.FormatOf("created_date", "body", "date-time", m.CreatedDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateDetails(formats strfmt.Registry) error {

	if err := validate.Required("details", "body", m.Details); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateMessage(formats strfmt.Registry) error {

	if err := validate.Required("message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateNotificationID(formats strfmt.Registry) error {

	if err := validate.Required("notification_id", "body", m.NotificationID); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateUserEmail(formats strfmt.Registry) error {

	if err := validate.Required("user_email", "body", m.UserEmail); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateUserUUID(formats strfmt.Registry) error {

	if err := validate.Required("user_uuid", "body", m.UserUUID); err != nil {
		return err
	}

	return nil
}

func (m *SadomainNotificationLog) validateUsername(formats strfmt.Registry) error {

	if err := validate.Required("username", "body", m.Username); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this sadomain notification log based on context it is used
func (m *SadomainNotificationLog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SadomainNotificationLog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SadomainNotificationLog) UnmarshalBinary(b []byte) error {
	var res SadomainNotificationLog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
