// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SadomainTyposquattingComponent sadomain typosquatting component
//
// swagger:model sadomain.TyposquattingComponent
type SadomainTyposquattingComponent struct {

	// Snapshot for the base domain of the infrastructure component
	// Required: true
	BaseDomain *SadomainTyposquattingBaseDomain `json:"base_domain"`

	// The ID of the infrastructure component
	// Required: true
	ID *string `json:"id"`

	// Snapshot for the parent domain of the infrastructure component
	// Required: true
	ParentDomain *SadomainTyposquattingParentDomain `json:"parent_domain"`

	// The Punycode representation of the infrastructure component, i.e. starting with `xn--`
	// Required: true
	PunycodeFormat *string `json:"punycode_format"`

	// submit for blocking info
	SubmitForBlockingInfo *SadomainSubmitForBlockingInfo `json:"submit_for_blocking_info,omitempty"`

	// The Unicode representation of the infrastructure component
	// Required: true
	UnicodeFormat *string `json:"unicode_format"`
}

// Validate validates this sadomain typosquatting component
func (m *SadomainTyposquattingComponent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBaseDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePunycodeFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubmitForBlockingInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnicodeFormat(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SadomainTyposquattingComponent) validateBaseDomain(formats strfmt.Registry) error {

	if err := validate.Required("base_domain", "body", m.BaseDomain); err != nil {
		return err
	}

	if m.BaseDomain != nil {
		if err := m.BaseDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("base_domain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("base_domain")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainTyposquattingComponent) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *SadomainTyposquattingComponent) validateParentDomain(formats strfmt.Registry) error {

	if err := validate.Required("parent_domain", "body", m.ParentDomain); err != nil {
		return err
	}

	if m.ParentDomain != nil {
		if err := m.ParentDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_domain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parent_domain")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainTyposquattingComponent) validatePunycodeFormat(formats strfmt.Registry) error {

	if err := validate.Required("punycode_format", "body", m.PunycodeFormat); err != nil {
		return err
	}

	return nil
}

func (m *SadomainTyposquattingComponent) validateSubmitForBlockingInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.SubmitForBlockingInfo) { // not required
		return nil
	}

	if m.SubmitForBlockingInfo != nil {
		if err := m.SubmitForBlockingInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("submit_for_blocking_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("submit_for_blocking_info")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainTyposquattingComponent) validateUnicodeFormat(formats strfmt.Registry) error {

	if err := validate.Required("unicode_format", "body", m.UnicodeFormat); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this sadomain typosquatting component based on the context it is used
func (m *SadomainTyposquattingComponent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBaseDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubmitForBlockingInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SadomainTyposquattingComponent) contextValidateBaseDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.BaseDomain != nil {

		if err := m.BaseDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("base_domain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("base_domain")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainTyposquattingComponent) contextValidateParentDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentDomain != nil {

		if err := m.ParentDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_domain")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parent_domain")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainTyposquattingComponent) contextValidateSubmitForBlockingInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.SubmitForBlockingInfo != nil {

		if swag.IsZero(m.SubmitForBlockingInfo) { // not required
			return nil
		}

		if err := m.SubmitForBlockingInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("submit_for_blocking_info")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("submit_for_blocking_info")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SadomainTyposquattingComponent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SadomainTyposquattingComponent) UnmarshalBinary(b []byte) error {
	var res SadomainTyposquattingComponent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
