// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SadomainWhoisRecord sadomain whois record
//
// swagger:model sadomain.WhoisRecord
type SadomainWhoisRecord struct {

	// The timestamp when the Whois snapshot was captured for a given domain
	// Format: date-time
	DateCollected strfmt.DateTime `json:"date_collected,omitempty"`

	// The timestamp when the Whois record was created
	// Format: date-time
	DateCreated strfmt.DateTime `json:"date_created,omitempty"`

	// The timestamp when the Whois record expires
	// Format: date-time
	DateExpires strfmt.DateTime `json:"date_expires,omitempty"`

	// The timestamp when the Whois record was updated
	// Format: date-time
	DateUpdated strfmt.DateTime `json:"date_updated,omitempty"`

	// The list of nameservers associated with a given domain
	NameServers []string `json:"name_servers"`

	// Details about the entity who registered a given domain
	Registrant *SadomainWhoisRegistrant `json:"registrant,omitempty"`

	// Details about the registrar of a given domain
	Registrar *SadomainWhoisRegistrar `json:"registrar,omitempty"`
}

// Validate validates this sadomain whois record
func (m *SadomainWhoisRecord) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDateCollected(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDateExpires(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDateUpdated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegistrant(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegistrar(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SadomainWhoisRecord) validateDateCollected(formats strfmt.Registry) error {
	if swag.IsZero(m.DateCollected) { // not required
		return nil
	}

	if err := validate.FormatOf("date_collected", "body", "date-time", m.DateCollected.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SadomainWhoisRecord) validateDateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.DateCreated) { // not required
		return nil
	}

	if err := validate.FormatOf("date_created", "body", "date-time", m.DateCreated.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SadomainWhoisRecord) validateDateExpires(formats strfmt.Registry) error {
	if swag.IsZero(m.DateExpires) { // not required
		return nil
	}

	if err := validate.FormatOf("date_expires", "body", "date-time", m.DateExpires.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SadomainWhoisRecord) validateDateUpdated(formats strfmt.Registry) error {
	if swag.IsZero(m.DateUpdated) { // not required
		return nil
	}

	if err := validate.FormatOf("date_updated", "body", "date-time", m.DateUpdated.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *SadomainWhoisRecord) validateRegistrant(formats strfmt.Registry) error {
	if swag.IsZero(m.Registrant) { // not required
		return nil
	}

	if m.Registrant != nil {
		if err := m.Registrant.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("registrant")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("registrant")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainWhoisRecord) validateRegistrar(formats strfmt.Registry) error {
	if swag.IsZero(m.Registrar) { // not required
		return nil
	}

	if m.Registrar != nil {
		if err := m.Registrar.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("registrar")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("registrar")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this sadomain whois record based on the context it is used
func (m *SadomainWhoisRecord) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRegistrant(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRegistrar(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SadomainWhoisRecord) contextValidateRegistrant(ctx context.Context, formats strfmt.Registry) error {

	if m.Registrant != nil {

		if swag.IsZero(m.Registrant) { // not required
			return nil
		}

		if err := m.Registrant.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("registrant")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("registrant")
			}
			return err
		}
	}

	return nil
}

func (m *SadomainWhoisRecord) contextValidateRegistrar(ctx context.Context, formats strfmt.Registry) error {

	if m.Registrar != nil {

		if swag.IsZero(m.Registrar) { // not required
			return nil
		}

		if err := m.Registrar.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("registrar")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("registrar")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SadomainWhoisRecord) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SadomainWhoisRecord) UnmarshalBinary(b []byte) error {
	var res SadomainWhoisRecord
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
