// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SensorUpdateBuildRespV1 sensor update build resp v1
//
// swagger:model sensor_update.BuildRespV1
type SensorUpdateBuildRespV1 struct {

	// build
	// Required: true
	Build *string `json:"build"`

	// platform
	// Required: true
	Platform *string `json:"platform"`

	// sensor version
	// Required: true
	SensorVersion *string `json:"sensor_version"`

	// The release stage this build is in
	// Required: true
	// Enum: [prod early_adopter]
	Stage *string `json:"stage"`
}

// Validate validates this sensor update build resp v1
func (m *SensorUpdateBuildRespV1) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBuild(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatform(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSensorVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SensorUpdateBuildRespV1) validateBuild(formats strfmt.Registry) error {

	if err := validate.Required("build", "body", m.Build); err != nil {
		return err
	}

	return nil
}

func (m *SensorUpdateBuildRespV1) validatePlatform(formats strfmt.Registry) error {

	if err := validate.Required("platform", "body", m.Platform); err != nil {
		return err
	}

	return nil
}

func (m *SensorUpdateBuildRespV1) validateSensorVersion(formats strfmt.Registry) error {

	if err := validate.Required("sensor_version", "body", m.SensorVersion); err != nil {
		return err
	}

	return nil
}

var sensorUpdateBuildRespV1TypeStagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["prod","early_adopter"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sensorUpdateBuildRespV1TypeStagePropEnum = append(sensorUpdateBuildRespV1TypeStagePropEnum, v)
	}
}

const (

	// SensorUpdateBuildRespV1StageProd captures enum value "prod"
	SensorUpdateBuildRespV1StageProd string = "prod"

	// SensorUpdateBuildRespV1StageEarlyAdopter captures enum value "early_adopter"
	SensorUpdateBuildRespV1StageEarlyAdopter string = "early_adopter"
)

// prop value enum
func (m *SensorUpdateBuildRespV1) validateStageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sensorUpdateBuildRespV1TypeStagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SensorUpdateBuildRespV1) validateStage(formats strfmt.Registry) error {

	if err := validate.Required("stage", "body", m.Stage); err != nil {
		return err
	}

	// value enum
	if err := m.validateStageEnum("stage", "body", *m.Stage); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this sensor update build resp v1 based on context it is used
func (m *SensorUpdateBuildRespV1) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SensorUpdateBuildRespV1) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SensorUpdateBuildRespV1) UnmarshalBinary(b []byte) error {
	var res SensorUpdateBuildRespV1
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
