// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SensorUpdateCreatePolicyReqV2 sensor update create policy req v2
//
// swagger:model sensor_update.CreatePolicyReqV2
type SensorUpdateCreatePolicyReqV2 struct {

	// The description to use when creating the policy
	Description string `json:"description,omitempty"`

	// The name to use when creating the policy
	// Required: true
	Name *string `json:"name"`

	// The name of the platform
	// Required: true
	// Enum: [Windows Mac Linux]
	PlatformName *string `json:"platform_name"`

	// The settings to create the policy with
	Settings *SensorUpdateSettingsReqV2 `json:"settings,omitempty"`
}

// Validate validates this sensor update create policy req v2
func (m *SensorUpdateCreatePolicyReqV2) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePlatformName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSettings(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SensorUpdateCreatePolicyReqV2) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

var sensorUpdateCreatePolicyReqV2TypePlatformNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Windows","Mac","Linux"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		sensorUpdateCreatePolicyReqV2TypePlatformNamePropEnum = append(sensorUpdateCreatePolicyReqV2TypePlatformNamePropEnum, v)
	}
}

const (

	// SensorUpdateCreatePolicyReqV2PlatformNameWindows captures enum value "Windows"
	SensorUpdateCreatePolicyReqV2PlatformNameWindows string = "Windows"

	// SensorUpdateCreatePolicyReqV2PlatformNameMac captures enum value "Mac"
	SensorUpdateCreatePolicyReqV2PlatformNameMac string = "Mac"

	// SensorUpdateCreatePolicyReqV2PlatformNameLinux captures enum value "Linux"
	SensorUpdateCreatePolicyReqV2PlatformNameLinux string = "Linux"
)

// prop value enum
func (m *SensorUpdateCreatePolicyReqV2) validatePlatformNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, sensorUpdateCreatePolicyReqV2TypePlatformNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SensorUpdateCreatePolicyReqV2) validatePlatformName(formats strfmt.Registry) error {

	if err := validate.Required("platform_name", "body", m.PlatformName); err != nil {
		return err
	}

	// value enum
	if err := m.validatePlatformNameEnum("platform_name", "body", *m.PlatformName); err != nil {
		return err
	}

	return nil
}

func (m *SensorUpdateCreatePolicyReqV2) validateSettings(formats strfmt.Registry) error {
	if swag.IsZero(m.Settings) { // not required
		return nil
	}

	if m.Settings != nil {
		if err := m.Settings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("settings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("settings")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this sensor update create policy req v2 based on the context it is used
func (m *SensorUpdateCreatePolicyReqV2) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSettings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SensorUpdateCreatePolicyReqV2) contextValidateSettings(ctx context.Context, formats strfmt.Registry) error {

	if m.Settings != nil {

		if swag.IsZero(m.Settings) { // not required
			return nil
		}

		if err := m.Settings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("settings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("settings")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SensorUpdateCreatePolicyReqV2) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SensorUpdateCreatePolicyReqV2) UnmarshalBinary(b []byte) error {
	var res SensorUpdateCreatePolicyReqV2
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
